# CVE-2025-52357 : Security Advisory: XSS in FD602GW-DX-R410 Router Admin Console
 Proof of Concept and Security Advisory for Reflected XSS vulnerability in the FD602GW-DX-R410 fiber router’s admin console (firmware V2.2.14). Includes details, impact, and mitigation guidance.

## Overview
A Cross-Site Scripting (XSS) vulnerability was discovered in the FD602GW-DX-R410 fiber router's admin web interface (Firmware V2.2.14). The ping diagnostic function improperly sanitizes input, allowing injection and execution of arbitrary JavaScript in the admin console context.

**CVE ID:** CVE-2025-52357  
**Advisory Publication Date:** July 10, 2025  
**Discovered by:** Hasanka Amarasinghe (Independent Security Researcher)  
**Vendor:** Shenzhen C-Data Technology Co., Ltd.  
**Product Affected:** FD602GW-DX-R410 Fiber Router  
**Firmware Version:** V2.2.14 (Build.1918.241111)  
**Hardware Version:** R410.1B  
**Bootloader Version:** V3.7-2312181457  
**Web Server:** Boa/0.93.15  
**Access Vector:** Remote (Authenticated)  
**Severity:** Medium

## CVSS v3.1 Base Score: 5.4 (Medium)

- Attack Vector: Network (Remote)
- Attack Complexity: Low
- Privileges Required: Low (authenticated user)
- User Interaction: Required (for CSRF)
- Scope: Changed
- Confidentiality Impact: Medium
- Integrity Impact: Medium
- Availability Impact: Low


## Affected Product
- **Device:** FD602GW-DX-R410 Fiber Router  
- **Firmware Version:** V2.2.14 (Build.1918.241111)  
- **Web Server:** Boa/0.93.15  

## Vulnerability Details
- **Type:** Reflected Cross-Site Scripting (XSS)  
- **Attack Vector:** Remote (authenticated user required)  
- **Impact:**  
  - Arbitrary JavaScript execution with admin privileges  
  - Potential session hijacking, credential theft  
  - Possible privilege escalation and unauthorized configuration changes  

## Proof of Concept (PoC)
Inject the following payload into the ping input field and submit:

```html
"><svg/onload=alert(1)>
```
![image](https://github.com/user-attachments/assets/b0b23747-4eb0-4c34-8099-95381a93fc2f)


On page load, the injected JavaScript executes, demonstrating the lack of input sanitization.




## Recommendations

- Implement strict server-side input validation and context-aware output encoding to prevent JavaScript injection.
- Prevent execution of arbitrary scripts in the admin interface inputs.
- Release a firmware update to address input sanitization issues.
- Advise users to update firmware promptly once a patch is available.
- Consider deploying Content Security Policy (CSP) headers to mitigate XSS impact.
- Restrict administrative access to trusted IP ranges.
- Educate users to avoid default or weak credentials.


## Attack Vector

- Requires authenticated access to the router’s admin interface (e.g., via weak/default credentials or insider access),  
  OR  
- Can be exploited via Cross-Site Request Forgery (CSRF) if the victim is an authenticated admin who visits a malicious link.

The vulnerability is triggered by injecting malicious input into the "target IP" field on the Ping diagnostic page.


## Impact

- Session hijacking via theft of authentication cookies.
- Privilege escalation through browser-based attacks.
- Unauthorized router configuration changes via injected JavaScript.
- Potential for CSRF attacks when combined with network access and victim interaction.


## References

    CVE: CVE-2025-52357

    Vendor: Shenzhen C-Data Technology Co., Ltd.

    Device: FD602GW-DX-R410

    Firmware: V2.2.14 (Build.1918.241111)

## Disclosure

Disclosure timeline

| Date         | Action                                                   |
| ------------ | -------------------------------------------------------- |
| Jun 2025     | Vulnerability discovered                                 |
| Jun 2025     | Attempted responsible disclosure to vendor (no response) |
| Jul 9, 2025  | CVE-2025-52357 assigned by MITRE                         |
| Jul 10, 2025 | Advisory publicly released                               |****

Discovered and responsibly disclosed by Hasanka Amarasinghe


## Disclaimer

This advisory is provided for security awareness and educational purposes only.


