# Letta-CVE-2025-51482-RCE
## 漏洞原因分析

### 1. 缺乏代码安全检查

问题: 系统没有对用户提供的源代码进行任何安全检查。

证据:

- generate_execution_script

  方法直接将用户代码插入到执行脚本中：

  python

  code += "\n" + self.tool.source_code + "\n"

- 没有AST分析来检测危险操作（如os.system、subprocess.call、eval等）

- 没有导入限制或模块白名单

### 2. 不安全的exec()使用

问题: 直接使用exec()执行用户代码，且全局字典包含环境变量。

证据:

python

globals_dict = *dict*(env) # 环境变量直接暴露给用户代码

exec(code_obj, globals_dict)

### 3. 环境变量暴露

问题: 所有环境变量都暴露给用户代码，包括敏感信息。

证据:

python

env = os.environ.copy() # 复制所有系统环境变量

env_vars = self.sandbox_config_manager.get_sandbox_env_vars_as_dict(...)

env.update(env_vars) # 添加沙箱环境变量

### 4. 沙箱绕过机制

问题: privileged_tools机制可以被绕过。

证据:

python

if tool_settings.e2b_api_key and not self.privileged_tools:

  \# 使用e2b沙箱（相对安全）

else:

  \# 使用本地沙箱（不安全）

如果组织设置了privileged_tools=True或没有配置e2b API密钥，系统会回退到不安全的本地执行。

### 5. 缺乏输入验证

问题: 对用户输入的源代码没有进行任何验证或清理。

证据: ToolRunFromSource模式接受任意字符串作为源代码：

python

source_code: *str* = Field(..., *description*="The source code of the function.")

## 攻击利用（python脚本）
```
例如：
python RCE.py -u http://192.168.63.131:8283/
[+] 命令执行成功:
uid=0(root) gid=0(root) groups=0(root)
python RCE.py -u http://192.168.63.131:8283/ -c whoami
[+] 命令执行成功:
root
```
