# 🛡️ CVE Disclosure: CVE-2025-51411 — Reflected XSS in Institute-of-Current-Students

**Disclosure Date:** 25 July 2025  
**CVE ID:** CVE-2025-51411  
**Severity:** MEDIUM (CVSS 6.1)

---

## 🧩 Summary

A reflected Cross-Site Scripting (XSS) vulnerability exists in the `Institute-of-Current-Students v1.0` project, specifically within the `postquerypublic` endpoint. Unsanitized input in the `email` parameter is directly reflected back into the response HTML, allowing attackers to execute arbitrary JavaScript in the browser of a user who visits a malicious link or submits a crafted request.

This issue has been assigned the identifier **CVE-2025-51411**. At the time of disclosure, **no patch** has been released by the vendor.

---

## 📦 Affected Product

- **Vendor:** Independent (mathurvishal)  
- **Project:** [Institute-of-Current-Students---PHP-Project](https://github.com/mathurvishal/Institute-of-Current-Students---PHP-Project)  
- **Version:** v1.0  
- **File:** `postquerypublic`  
- **Vulnerable Endpoint:**  
  `http://localhost/Institute-of-Current-Students/postquerypublic`

---

## 🔬 Vulnerability Details

The server fails to properly sanitize the `email` parameter from POST data before reflecting it into the response HTML. This allows attackers to inject JavaScript payloads, leading to client-side code execution.

### Vulnerable Code Pattern (hypothetical):
```php
$email = $_POST['email'];
echo "<div>Email: $email</div>";
```

---

## 📌 CWE Classification

| CWE ID | Title                                                                 |
|--------|-----------------------------------------------------------------------|
| [CWE-79](https://cwe.mitre.org/data/definitions/79.html) | Improper Neutralization of Input During Web Page Generation ('Cross-site Scripting') |

---

## 📊 CVSS v3.1 Score

| Score | Severity | Vector String                              |
|-------|----------|---------------------------------------------|
| 6.1   | MEDIUM   | `CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:N` |

---

## 💥 Impact

A successful exploitation could result in:

- 🧠 **Execution of arbitrary JavaScript**
- 🎭 **Phishing or impersonation** via HTML injection
- 🍪 **Session hijacking or token theft**
- 🚨 **Forced redirection or malware delivery**

---

## 🧪 Proof of Concept (PoC)

### 📥 Sample Request
```http
POST /Institute-of-Current-Students/postquerypublic HTTP/1.1
Host: localhost
Content-Type: application/x-www-form-urlencoded

email=testing%40example.com'"()%26%25<zzz><ScRiPt%20>IZwW(9455)</ScRiPt>&gnamex=pHqghUme&squeryx=555&update=Post%20Query!
```

### 📋 Injected Payload
```html
<ScRiPt >IZwW(9455)</ScRiPt>
```

This payload is executed if the server reflects the email value without sanitization.

---

## 🔐 Recommendations

- ✅ Use `htmlspecialchars()` or equivalent to encode all untrusted output before rendering to HTML.
- 🧰 Implement **server-side input validation** for all form inputs.
- 🧱 Set strong **Content Security Policy (CSP)** headers.
- 🚫 Avoid directly embedding unsanitized user inputs into HTML responses.

### ✅ Example Fix
```php
$email = htmlspecialchars($_POST['email'], ENT_QUOTES, 'UTF-8');
```

---

## 📆 Timeline

| Event                    | Date           |
|--------------------------|----------------|
| Vulnerability Discovered | 18 July 2025   |
| Public Disclosure        | 25 July 2025   |
| Patch Available          | ❌ Not available as of disclosure |

---

## 🙋‍♂️ Credits

This vulnerability was discovered and disclosed by:

**Tansique Dasari**  
🔗 [GitHub](https://github.com/phantomtrace)  
✉️ [tansique.d@gmail.com](mailto:tansique.d@gmail.com)

---

## 🔗 References

- [OWASP - XSS](https://owasp.org/www-community/attacks/xss/)
- [CWE-79 - XSS Classification](https://cwe.mitre.org/data/definitions/79.html)
- [GitHub - Institute-of-Current-Students](https://github.com/mathurvishal/Institute-of-Current-Students---PHP-Project)
- [CVE-2025-51411 on CVE.org](https://cve.org/CVERecord?id=CVE-2025-51411)

---

> 💬 *This advisory is published independently due to absence of an official vendor patch.*
