### 🔐 CVE-2023-51385 - OpenSSH ProxyCommand Injection PoC

This repository contains a **proof-of-concept** for CVE-2023-51385, a command injection vulnerability in **OpenSSH's ProxyCommand** option. An attacker with control over SSH configuration or untrusted `ProxyCommand` strings can potentially achieve arbitrary code execution.

📌 **Impact**: Arbitrary command execution via malicious or improperly handled `ProxyCommand` values.
⚠️ **Affected Versions**: OpenSSH versions prior to the patch for CVE-2023-51385.
🔬 **PoC**: Demonstrates how exploitation can occur using a crafted SSH config or command-line input.

> **Note**: This PoC is for **educational and authorized testing purposes only**. Do not use against systems without permission.
>
## Summary

CVE-2023-51385 is a **command injection vulnerability** affecting OpenSSH's `ProxyCommand` option. Under specific conditions, an attacker can exploit improper escaping in SSH configuration or arguments to inject arbitrary commands.

This repository provides a **Proof-of-Concept (PoC)** demonstrating the vulnerability for **educational and authorized penetration testing**.

---

## ⚠️ Affected Versions

- **OpenSSH prior to version 9.8**  
- Vulnerable platforms include Unix/Linux systems where SSH client-side configs or CLI arguments are user-controlled.

---

## 🧠 Vulnerability Details

The issue arises due to **improper sanitization of the `ProxyCommand` value**. If an attacker can influence the `ProxyCommand` field in `.ssh/config` or via CLI, they may inject shell commands.

[CLick Here](https://youtu.be/-ZZ5txOVyGE) for the Youtube video for PoC.
