# CVE-2025-51006 – Double Free in tcpreplay 4.5.1 leads to DoS

**Affected Product:** tcpreplay  
**Vendod:** Appneta  
**Affected Version(s):** 4.5.1  
**Fixed Version:** 4.5.2  
**Vulnerability Type:** Double Free (CWE-415)  
**Impact:** Denial of Service  

## Description
In tcpreplay **4.5.1**, the `tcprewrite` utility can trigger a **double free** during the DLT plugin cleanup path when closing the tcpedit context after processing a crafted file. Under these conditions, the same pointer is freed twice, which aborts the process and results in a **Denial of Service (DoS)**.

## Trigger
**Trigger / Reproduction**  
1) Build tcpreplay 4.5.1 (building with ASan helps but is not required).  
2) Run: src/tcprewrite -i ./poc -o /dev/null 


## Sanitizer log
<img width="800" height="400" alt="image" src="https://github.com/user-attachments/assets/29487956-71b8-4118-a204-1823fd0e3d89" />

## Reference
https://github.com/appneta/tcpreplay/issues/926

## PoC
[poc.zip](https://github.com/user-attachments/files/22300744/poc.zip)
