# CVE-2025-51005 – Heap Buffer Overflow in tcpliveplay checksum calculation

**Affected Product:** tcpreplay  
**Vendod:** Appneta  
**Affected Version(s):** 4.5.1  
**Fixed Version:** Not yet.  
**Vulnerability Type:** Heap Buffer Overflow (CWE-122)  
**Impact:** Denial of Service  

## Description
A heap buffer overflow vulnerability exists in the tcpliveplay.  
When handling crafted pcap files, the program miscalculates the remaining packet length derived from the IPv4 header. This unchecked value is later used in checksum operations, resulting in memory access beyond the allocated buffer.  
The vendor has announced that this function will be removed starting from version 4.6.  

## Trigger
**Trigger / Reproduction**  
1) Build tcpreplay 4.5.1 (building with ASan helps but is not required).  
2) Run: sudo ./src/tcpliveplay eth0 ./a.pcap 0.0.0.0 00:00:00:00:00:00 random


## Sanitizer log

<img width="1589" height="604" alt="image" src="https://github.com/user-attachments/assets/1454c746-45d1-49e2-ba79-ba1c6478c890" />

## Reference
https://github.com/appneta/tcpreplay/issues/925

## PoC
[poc.zip](https://github.com/user-attachments/files/22483651/poc.zip)

