from flask import Flask, request, jsonify, send_from_directory
import os

app = Flask(__name__, static_folder='.')  


password = None


@app.route('/', defaults={'path': ''})
@app.route('/<path:path>')
def serve_static(path):
    return send_from_directory(app.static_folder, path)


@app.route('/version.json')
def version():
    return jsonify({"Version": "1.0.38"})

@app.route('/nonce.json')
def nonce():
    return jsonify({"Nonce": "testnonce"})


@app.route('/post.json', methods=['POST'])
def post_json():
    data = request.form
    global password
    if 'UserPassword0' in data:
        password = data['UserPassword0']
        return jsonify({"success": True}), 200
    elif 'UsersSaveConfig' in data and data['UsersSaveConfig'] == 'true':
        return jsonify({"saved": True}), 200
    return jsonify({"error": "Invalid request"}), 400


@app.route('/check_password')
def check_password():
    return jsonify({"current_password": password})

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=8080, debug=True)
