Poppler before version 25.07.0 contains a vulnerability in its pdfseparate utility's PDFDoc processing logic: crafted "/Annots" dictionaries that reference themselves or each other lead to infinite recursion in "PDFDoc::markAnnotations --> PDFDoc::markPageObjects --> PDFDoc::markObject --> PDFDoc::markDictionary", because loop detection uses dictionary pointer addresses which differ on each fetch(). A remote attacker can cause a denial-of-service (application hang or crash) by processing a malicious PDF.

Here i craft a malicious PDF(poppler-pdfseparate-poc) where "/Annots" resolves to a self-referencing or mutually referencing dictionary, causing Poppler's markAnnotations --> markPageObjects --> markObject --> markDictionary recursion to never detect the loop and thus exhaust the call stack (infinite recursion). Exploitation requires only opening or processing the PDF (e.g., via pdfseparate).

The reproduction process is as follows：
```bash
afl_env(base) user@ubuntu:~/zgd/AFLProject/pdf_parsers/poppler-25.04.0/build/utils$ ./pdfseparate ./../../../../pdf_fuzz/p
oppler-master/pdfseparate/analyze_crashes/only_custom/all_crashes/poppler-pdfseparate-poc /dev/null
Segmentation fault (core dumped)

afl_env(base) user@ubuntu:~/zgd/AFLProject/pdf_parsers/poppler-25.04.0/build/utils$ gdb ./pdfseparate core.2332378 
GNU gdb (Ubuntu 12.1-0ubuntu1~22.04.2) 12.1
Copyright (C) 2022 Free Software Foundation, Inc.
License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>
This is free software: you are free to change and redistribute it.
There is NO WARRANTY, to the extent permitted by law.
Type "show copying" and "show warranty" for details.
This GDB was configured as "x86_64-linux-gnu".
Type "show configuration" for configuration details.
For bug reporting instructions, please see:
<https://www.gnu.org/software/gdb/bugs/>.
Find the GDB manual and other documentation resources online at:
    <http://www.gnu.org/software/gdb/documentation/>.

For help, type "help".
Type "apropos word" to search for commands related to "word"...
Reading symbols from ./pdfseparate...
[New LWP 2332378]
[Thread debugging using libthread_db enabled]
Using host libthread_db library "/lib/x86_64-linux-gnu/libthread_db.so.1".
--Type <RET> for more, q to quit, c to continue without paging--
Core was generated by `./pdfseparate ./../../../../pdf_fuzz/poppler-master/pdfseparate/analyze_crashes'.
Program terminated with signal SIGSEGV, Segmentation fault.
#0  0x00007a27410a3dee in _int_malloc (av=av@entry=0x7a274121ac80 <main_arena>, bytes=bytes@entry=40)
    at ./malloc/malloc.c:3903
3903    ./malloc/malloc.c: No such file or directory.
(gdb) bt
#0  0x00007a27410a3dee in _int_malloc (av=av@entry=0x7a274121ac80 <main_arena>, bytes=bytes@entry=40)
    at ./malloc/malloc.c:3903
#1  0x00007a27410a5262 in __GI___libc_malloc (bytes=40) at ./malloc/malloc.c:3321
#2  0x00007a27414ae98c in operator new(unsigned long) () from /lib/x86_64-linux-gnu/libstdc++.so.6
#3  0x00007a274192a080 in __gnu_cxx::new_allocator<std::_Rb_tree_node<int> >::allocate (this=0x5c29c1b2a498, __n=1)
    at /usr/include/c++/11/ext/new_allocator.h:127
#4  0x00007a2741929c8f in std::allocator<std::_Rb_tree_node<int> >::allocate (__n=1, this=0x5c29c1b2a498)
    at /usr/include/c++/11/bits/allocator.h:185
#5  std::allocator_traits<std::allocator<std::_Rb_tree_node<int> > >::allocate (__a=..., __n=1)
    at /usr/include/c++/11/bits/alloc_traits.h:464
#6  0x00007a274192974f in std::_Rb_tree<int, int, std::_Identity<int>, std::less<int>, std::allocator<int> >::_M_get_node
    (this=0x5c29c1b2a498) at /usr/include/c++/11/bits/stl_tree.h:561
#7  0x00007a2741973466 in std::_Rb_tree<int, int, std::_Identity<int>, std::less<int>, std::allocator<int> >::_M_create_node<int const&> (this=0x5c29c1b2a498) at /usr/include/c++/11/bits/stl_tree.h:611
#8  0x00007a2741970c97 in std::_Rb_tree<int, int, std::_Identity<int>, std::less<int>, std::allocator<int> >::_Alloc_node::operator()<int const&> (this=0x7ffeba55f200, __arg=@0x7ffeba55f2a0: 4) at /usr/include/c++/11/bits/stl_tree.h:529
#9  0x00007a274196ba22 in std::_Rb_tree<int, int, std::_Identity<int>, std::less<int>, std::allocator<int> >::_M_insert_<int const&, std::_Rb_tree<int, int, std::_Identity<int>, std::less<int>, std::allocator<int> >::_Alloc_node> (
    this=0x5c29c1b2a498, __x=0x0, __p=0x5c29c1b2a4a0, __v=@0x7ffeba55f2a0: 4, __node_gen=...)
    at /usr/include/c++/11/bits/stl_tree.h:1784
#10 0x00007a2741963f5e in std::_Rb_tree<int, int, std::_Identity<int>, std::less<int>, std::allocator<int> >::_M_insert_unique<int const&> (this=0x5c29c1b2a498, __v=@0x7ffeba55f2a0: 4) at /usr/include/c++/11/bits/stl_tree.h:2129
#11 0x00007a274195c4f6 in std::set<int, std::less<int>, std::allocator<int> >::insert (this=0x5c29c1b2a498, 
--Type <RET> for more, q to quit, c to continue without paging--
    __x=@0x7ffeba55f2a0: 4) at /usr/include/c++/11/bits/stl_set.h:512
#12 0x00007a2741957c6d in RefRecursionChecker::insert (this=0x5c29c1b2a498, ref=...)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/Object.h:133
#13 0x00007a2741b0e09c in XRef::fetch (this=0x5c29c1b2a370, num=4, gen=0, recursion=0, endPos=0x0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/XRef.cc:1202
#14 0x00007a2741b0dfb4 in XRef::fetch (this=0x5c29c1b2a370, ref=..., recursion=0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/XRef.cc:1190
#15 0x00007a2741a94e1d in Object::fetch (this=0x5c29c208a1c0, xref=0x5c29c1b2a370, recursion=0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/Object.cc:110
#16 0x00007a27419785d3 in Array::get (this=0x5c29c208a160, i=0, recursion=0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/Array.cc:92
#17 0x00007a2741ab0514 in PDFDoc::markAnnotations (this=0x5c29c1b2a0a0, annotsObj=0x7ffeba55f6b0, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldPageNum=3, newPageNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1856
#18 0x00007a2741aaf6b3 in PDFDoc::markDictionary (this=0x5c29c1b2a0a0, dict=0x5c29c208a100, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldRefNum=3, newRefNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1716
#19 0x00007a2741aaf8d8 in PDFDoc::markObject (this=0x5c29c1b2a0a0, obj=0x7ffeba55f800, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldRefNum=3, newRefNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1744
#20 0x00007a2741ab03af in PDFDoc::markPageObjects (this=0x5c29c1b2a0a0, pageDict=0x5c29c208a0a0, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldRefNum=3, newRefNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1840
--Type <RET> for more, q to quit, c to continue without paging--
#21 0x00007a2741ab0827 in PDFDoc::markAnnotations (this=0x5c29c1b2a0a0, annotsObj=0x7ffeba55f9a0, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldPageNum=3, newPageNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1889
#22 0x00007a2741aaf6b3 in PDFDoc::markDictionary (this=0x5c29c1b2a0a0, dict=0x5c29c2089f10, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldRefNum=3, newRefNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1716
#23 0x00007a2741aaf8d8 in PDFDoc::markObject (this=0x5c29c1b2a0a0, obj=0x7ffeba55faf0, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldRefNum=3, newRefNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1744
#24 0x00007a2741ab03af in PDFDoc::markPageObjects (this=0x5c29c1b2a0a0, pageDict=0x5c29c2089eb0, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldRefNum=3, newRefNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1840
#25 0x00007a2741ab0827 in PDFDoc::markAnnotations (this=0x5c29c1b2a0a0, annotsObj=0x7ffeba55fc90, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldPageNum=3, newPageNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1889
#26 0x00007a2741aaf6b3 in PDFDoc::markDictionary (this=0x5c29c1b2a0a0, dict=0x5c29c2089d20, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldRefNum=3, newRefNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1716
#27 0x00007a2741aaf8d8 in PDFDoc::markObject (this=0x5c29c1b2a0a0, obj=0x7ffeba55fde0, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldRefNum=3, newRefNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1744
#28 0x00007a2741ab03af in PDFDoc::markPageObjects (this=0x5c29c1b2a0a0, pageDict=0x5c29c2089cc0, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldRefNum=3, newRefNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
--Type <RET> for more, q to quit, c to continue without paging--
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1840
#29 0x00007a2741ab0827 in PDFDoc::markAnnotations (this=0x5c29c1b2a0a0, annotsObj=0x7ffeba55ff80, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldPageNum=3, newPageNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1889
#30 0x00007a2741aaf6b3 in PDFDoc::markDictionary (this=0x5c29c1b2a0a0, dict=0x5c29c2089b30, xRef=0x5c29c1b2b080, 
    countRef=0x5c29c1b2b240, numOffset=0, oldRefNum=3, newRefNum=259, alreadyMarkedDicts=0x5c29c1b2c9f0)
    at /home/user/zgd/AFLProject/pdf_parsers/poppler-25.04.0/poppler/PDFDoc.cc:1716
```

The vendor (freedesktop, maintainer of Poppler) has acknowledged the issue and fixed the bug. The fix has been committed in their official repository.

Here is the public link to the patch / commit provided by the vendor:

https://gitlab.freedesktop.org/poppler/poppler/-/issues/1613<br>
https://gitlab.freedesktop.org/poppler/poppler/-/merge_requests/1849<br>
https://gitlab.freedesktop.org/poppler/poppler/-/commit/08d7894e4dd0e313c179e30f06ad8f546619b1b3

This confirms that the vulnerability has been acknowledged and remediated.
