# Heap Buffer Overflow in Pepper Language

[Pepper Language](https://github.com/dannyvankooten/pepper-lang) is a fast interpreted programming language for simplicity and verbosity. It is dynamically typed and supports garbage collection.

* Affected Version: Version 0.1.1 and before, Commit 961a5d9988c5986d563310275adad3fd181b2bb7 and before.
* Status: Unfixed; no any update since Feb 15, 2024.

## How to Reproduce (PoC)

Create a file with more than 65 numbers in a column. For example,

```vb
1
2
3
4
5
6
7
8
9
10
11
12
13
14
15
16
17
18
19
20
21
22
23
24
25
26
27
28
29
30
31
32
33
34
35
36
37
38
39
40
41
42
43
44
45
46
47
48
49
50
51
52
53
54
55
56
57
58
59
60
61
62
63
64
65
```

It would crash the compiled pepper language compiler `pepper`. The below is the result of crash with AddressSanitizer.

```vb
=================================================================
==319391==ERROR: AddressSanitizer: heap-buffer-overflow on address 0x619000000980 at pc 0x5d0c243bf4f5 bp 0x7fff8342bf10 sp 0x7fff8342bf08
WRITE of size 4 at 0x619000000980 thread T0
    #0 0x5d0c243bf4f4 in add_constant /home/ch1keen/fuzz/pepper-lang/src/compiler.c:91:50
    #1 0x5d0c243bf4f4 in compile_expression /home/ch1keen/fuzz/pepper-lang/src/compiler.c:445:45
    #2 0x5d0c243bc551 in compile_statement /home/ch1keen/fuzz/pepper-lang/src/compiler.c:212:19
    #3 0x5d0c243bc28d in compile_program /home/ch1keen/fuzz/pepper-lang/src/compiler.c:180:15
    #4 0x5d0c243a82dc in run_script /home/ch1keen/fuzz/pepper-lang/src/pepper.c:129:12
    #5 0x5d0c243a82dc in main /home/ch1keen/fuzz/pepper-lang/src/pepper.c:161:9
    #6 0x768a81e2a1c9 in __libc_start_call_main csu/../sysdeps/nptl/libc_start_call_main.h:58:16
    #7 0x768a81e2a28a in __libc_start_main csu/../csu/libc-start.c:360:3
    #8 0x5d0c242e8434 in _start (/home/ch1keen/fuzz/pepper-lang/bin/pepper+0x29434) (BuildId: b8341ebeb041c31389178ec76172705c296f6f5d)

0x619000000980 is located 0 bytes to the right of 1024-byte region [0x619000000580,0x619000000980)
allocated by thread T0 here:
    #0 0x5d0c2436be42 in __interceptor_malloc (/home/ch1keen/fuzz/pepper-lang/bin/pepper+0xace42) (BuildId: b8341ebeb041c31389178ec76172705c296f6f5d)
    #1 0x5d0c243c39fb in make_object_list /home/ch1keen/fuzz/pepper-lang/src/object.c:187:37
    #2 0x5d0c243b945d in compiler_new /home/ch1keen/fuzz/pepper-lang/src/compiler.c:37:20
    #3 0x5d0c243a82ce in run_script /home/ch1keen/fuzz/pepper-lang/src/pepper.c:128:30
    #4 0x5d0c243a82ce in main /home/ch1keen/fuzz/pepper-lang/src/pepper.c:161:9
    #5 0x768a81e2a1c9 in __libc_start_call_main csu/../sysdeps/nptl/libc_start_call_main.h:58:16
    #6 0x768a81e2a28a in __libc_start_main csu/../csu/libc-start.c:360:3
    #7 0x5d0c242e8434 in _start (/home/ch1keen/fuzz/pepper-lang/bin/pepper+0x29434) (BuildId: b8341ebeb041c31389178ec76172705c296f6f5d)

SUMMARY: AddressSanitizer: heap-buffer-overflow /home/ch1keen/fuzz/pepper-lang/src/compiler.c:91:50 in add_constant
Shadow bytes around the buggy address:
  0x0c327fff80e0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x0c327fff80f0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x0c327fff8100: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x0c327fff8110: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x0c327fff8120: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
=>0x0c327fff8130:[fa]fa fa fa fa fa fa fa fa fa fa fa fa fa fa fa
  0x0c327fff8140: fa fa fa fa fa fa fa fa fa fa fa fa fa fa fa fa
  0x0c327fff8150: fa fa fa fa fa fa fa fa fa fa fa fa fa fa fa fa
  0x0c327fff8160: fa fa fa fa fa fa fa fa fa fa fa fa fa fa fa fa
  0x0c327fff8170: fa fa fa fa fa fa fa fa fa fa fa fa fa fa fa fa
  0x0c327fff8180: fa fa fa fa fa fa fa fa fa fa fa fa fa fa fa fa
Shadow byte legend (one shadow byte represents 8 application bytes):
  Addressable:           00
  Partially addressable: 01 02 03 04 05 06 07 
  Heap left redzone:       fa
  Freed heap region:       fd
  Stack left redzone:      f1
  Stack mid redzone:       f2
  Stack right redzone:     f3
  Stack after return:      f5
  Stack use after scope:   f8
  Global redzone:          f9
  Global init order:       f6
  Poisoned by user:        f7
  Container overflow:      fc
  Array cookie:            ac
  Intra object redzone:    bb
  ASan internal:           fe
  Left alloca redzone:     ca
  Right alloca redzone:    cb
==319391==ABORTING
```

## Root Cause

The compiler structure have `scopes` variable, and it has a fixed size array that can have 64 `compiler_scope` structures.

```c
// src/compiler.h
struct compiler {
    struct object_list *constants;
    struct symbol_table *symbol_table;
    uint32_t scope_index;
    struct compiler_scope scopes[64];
};
```

When the Proof-of-Concept file is passed to the compiler, the file is lexed and parsed first. Each constants are converted to `compiler_scope` typed variables. But since the `compiler` structure can only store 64 `compiler_scope`s, more than 65 `compiler_scope`s in a file causes heap buffer overflow.

Note: Since maintainer did not respond to a security concern mail &mdash; See the timeline for reference &mdash; and the issue tab of the repository of pepper language is closed, it cannot be confirmed.

## Impact

Heap buffer overflow can attackers not only modify the content of other heap objects, which can be content of other constants in pepper, but also make attackers the program to execute arbitrary code.

## Disclosure Timeline

* 2025.04.26: Vulnerability report sent to the maintainer(hi@dvk.co).
* 2025.04.26: Reported to MITRE.
* 2025.07.25: Public Disclosure.
* 2025.08.13: MITRE assigned [CVE-2025-50360](https://www.cve.org/CVERecord?id=CVE-2025-50360).
