# CVE-2025-50165 Windows Graphics Component RCE (x64)

> Critical Remote Code Execution via malicious JPEG – Windows 11 24H2 (unpatched)  
> CVSS 9.8 – No privileges, no interaction required

```
CVE-2025-50165 - windowscodecs.dll untrusted pointer dereference
Discovered by Zscaler ThreatLabz
Patched: November 2025 (KB5040442)
```

## Features
- Full x64 null-free shellcode (calc.exe spawner – 169 bytes)
- Heap spray + ROP chain inside APP1/EXIF segments
- Polymorphic NOP sled + randomized lengths for AV/EDR evasion
- Single Python file – no dependencies beyond Pillow

## Files
```
poc/                     → Final weaponized JPEGs
scripts/generate_poc.py  → Main generator (Encrypter15)
shellcode/calc_x64.bin   → Raw shellcode for analysis
README.md                → This file
```

## Quick Start
```bash
pip install Pillow
python scripts/generate_poc.py
```
→ Generates `poc/CVE-2025-50165_x64_encrypter15.jpg`

Open the JPEG with Photos, Office, Edge preview, etc. → `calc.exe` spawns instantly on vulnerable systems.

## Legal
For authorized security testing and research only. Do not use against systems without explicit permission.

## Author
**Encrypter15** – encrypter15@gmail.com

Stay frosty.
