Java.perform(() => {
    const AvtechLib = Java.use("push.lite.avtech.com.AvtechLib");

    // Print the original value of SDK_API_26
    const originalValue = AvtechLib.SDK_API_26.value;
    console.log(`[+] 기존 SDK_API_26 값: ${originalValue}`);

    // Set the value to false: Emulates an environment below Android 8.0 (API level 26)
    AvtechLib.SDK_API_26.value = false;
    console.log(`[+] SDK_API_26 값을 false로 설정함`);

    // Detect attempts to modify the value
    Object.defineProperty(AvtechLib, "SDK_API_26", {
        set: function (val) {
            console.log(`[-] SDK_API_26 값을 ${val}로 변경하려는 시도 감지됨`);
        },
        get: function () {
            return false;
        }
    });

    // Hooking GetHttpsResponse(String)
    AvtechLib.GetHttpsResponse.overload("java.lang.String").implementation = function (url) {
        console.log("[*] GetHttpsResponse 호출됨 (String)"); //GetHttpsResponse (String) Called.
        console.log("URL:", url);
        const result = this.GetHttpsResponse(url);
        console.log("Response:", result);
        return result;
    };

    // Hooking GetHttpsResponse(String, int)
    AvtechLib.GetHttpsResponse.overload("java.lang.String", "int").implementation = function (url, timeout) {
        console.log("[*] GetHttpsResponse 호출됨 (String, int)"); //GetHttpsResponse (String, int) Called.
        console.log("URL:", url);
        console.log("Timeout:", timeout);
        const result = this.GetHttpsResponse(url, timeout);
        console.log("Response:", result);
        return result;
    };
});