class RopChain {
  constructor(memory, base = 0n) {
    this.memory = memory;
    this.base = BigInt(base);
    this.chain = [];
  }

  push(value) {
    this.chain.push(BigInt(value));
    return this;
  }

  // Convenience helper that mirrors a typical "call gadget" layout.
  pushCall(gadgetAddr, ...args) {
    this.push(gadgetAddr);
    args.forEach(arg => this.push(arg));
    return this;
  }

  finalize() {
    const chainSize = this.chain.length * 8;
    const chainAddr = this.memory.allocate(chainSize);
    this.chain.forEach((value, index) => {
      this.memory.write64(chainAddr + index * 8, this.base + value);
    });
    return chainAddr;
  }

  get length() {
    return this.chain.length;
  }
}

module.exports = { RopChain };
