import base64
import hmac
import hashlib
import json
from Crypto.Cipher import AES
from Crypto.Util.Padding import unpad

encrypted_payload_b64 = """


xxx
"""

# Base64-encoded Laravel APP_KEY (without 'base64:' prefix)
app_key_b64 = "xxx"

# ================================================

def decrypt_laravel_cookie(encrypted_payload_b64: str, key_b64: str) -> bytes:
    """
    Decrypt a Laravel encrypted cookie (AES-256-CBC JSON payload) and return raw bytes.
    """
    key = base64.b64decode(key_b64)
    payload_json = base64.b64decode(encrypted_payload_b64)
    payload = json.loads(payload_json)

    print("Decrypted payload:", payload)
    # Validate MAC
    iv_b64 = payload['iv']
    value_b64 = payload['value']
    mac_data = iv_b64.encode('utf-8') + value_b64.encode('utf-8')
    mac_expected = hmac.new(key, mac_data, hashlib.sha256).hexdigest()
    if not hmac.compare_digest(payload.get('mac', ''), mac_expected):
        raise ValueError("MAC validation failed.")

    # Decrypt
    iv = base64.b64decode(iv_b64)
    ciphertext = base64.b64decode(value_b64)
    cipher = AES.new(key, AES.MODE_CBC, iv)
    return unpad(cipher.decrypt(ciphertext), AES.block_size)

def main():
    # Decrypt and parse cookie
    raw = decrypt_laravel_cookie(encrypted_payload_b64, app_key_b64)
    print(raw)


if __name__ == '__main__':
    main()