# Testing Checklist for Invision Community SQLi Exploit

## Pre-Deployment Testing

### 1. Code Quality Tests

#### Syntax Check
```powershell
# Check for syntax errors
python -m py_compile invision-sqli-exploit.py
```
**Expected:** No output = success

#### Linting
```powershell
# Install linters if not already installed
pip install flake8 pylint

# Run flake8
flake8 invision-sqli-exploit.py --max-line-length=100

# Run pylint
pylint invision-sqli-exploit.py --max-line-length=100
```
**Expected:** No critical errors

#### Code Formatting
```powershell
# Install black
pip install black

# Check formatting
black --check --line-length=100 invision-sqli-exploit.py

# Auto-format if needed
black --line-length=100 invision-sqli-exploit.py
```

### 2. Dependency Tests

#### Install Dependencies
```powershell
pip install -r requirements.txt
```
**Expected:** All packages install successfully

#### Verify Imports
```powershell
python -c "import requests; import colorama; print('All dependencies OK')"
```
**Expected:** "All dependencies OK"

### 3. Functional Tests

#### Help Command
```powershell
python invision-sqli-exploit.py --help
```
**Expected:** Help message displays correctly

#### Version Detection (if implemented)
```powershell
python invision-sqli-exploit.py --version
```

#### Invalid Arguments
```powershell
# Missing required argument
python invision-sqli-exploit.py

# Invalid URL format
python invision-sqli-exploit.py -u "not-a-url"
```
**Expected:** Appropriate error messages

### 4. Example Scripts Tests

#### Custom Query Example
```powershell
cd examples
python custom_query_example.py --help
```
**Expected:** Help message displays

#### Batch Testing Example
```powershell
python batch_testing_example.py --help
```
**Expected:** Help message displays

#### Proxy Example
```powershell
python proxy_example.py --help
```
**Expected:** Help message displays

### 5. Documentation Tests

#### Check All Files Exist
```powershell
Test-Path README.md
Test-Path LICENSE
Test-Path requirements.txt
Test-Path SETUP.md
Test-Path USAGE.md
Test-Path CONTRIBUTING.md
Test-Path SECURITY.md
Test-Path CHANGELOG.md
Test-Path .gitignore
Test-Path PROJECT_SUMMARY.md
Test-Path GITHUB_SETUP.md
Test-Path TECHNICAL_DIAGRAM.md
```
**Expected:** All return True

#### Markdown Validation (optional)
```powershell
# Install markdown-lint (requires Node.js)
npm install -g markdownlint-cli

# Check markdown files
markdownlint *.md
```

### 6. Cross-Platform Tests

#### Windows PowerShell
```powershell
# Test on Windows
python invision-sqli-exploit.py -u http://example.com/ -v
# Press Ctrl+C to cancel
```

#### Windows Command Prompt (cmd)
```cmd
python invision-sqli-exploit.py -u http://example.com/ -v
```

#### Git Bash (Windows)
```bash
python invision-sqli-exploit.py -u http://example.com/ -v
```

### 7. Edge Cases Tests

#### Very Long URL
```powershell
python invision-sqli-exploit.py -u "http://very-long-domain-name-that-goes-on-and-on.com/with/a/very/long/path/to/the/forum/installation/"
```

#### Special Characters in URL
```powershell
python invision-sqli-exploit.py -u "http://example.com/forum?test=value&other=123"
```

#### Localhost Testing
```powershell
python invision-sqli-exploit.py -u "http://localhost:8080/forum/"
```

#### IPv6 URL (if supported)
```powershell
python invision-sqli-exploit.py -u "http://[::1]/forum/"
```

## Integration Tests

### 1. GitHub Actions Simulation

```powershell
# Run the same checks that GitHub Actions would run

# Python 3.7 test (if available)
py -3.7 invision-sqli-exploit.py --help

# Python 3.8 test
py -3.8 invision-sqli-exploit.py --help

# Python 3.9 test
py -3.9 invision-sqli-exploit.py --help

# Python 3.10 test
py -3.10 invision-sqli-exploit.py --help

# Python 3.11 test
py -3.11 invision-sqli-exploit.py --help
```

### 2. Git Tests

```powershell
# Initialize git if not already done
git init

# Check status
git status

# Add all files
git add .

# Check for large files
git ls-files | ForEach-Object { if ((Get-Item $_).Length -gt 10MB) { Write-Host "Large file: $_" } }
```

### 3. Security Scan

```powershell
# Install bandit for security scanning
pip install bandit

# Run security scan
bandit -r . -f txt -o security-report.txt

# View report
Get-Content security-report.txt
```

## Manual Testing Checklist

### User Experience
- [ ] Banner displays correctly with colors
- [ ] Progress indicator updates in real-time
- [ ] Error messages are clear and helpful
- [ ] Success message is prominent and clear
- [ ] Consent prompt works correctly
- [ ] Verbose mode provides useful debug info

### Functionality
- [ ] CSRF token extraction works
- [ ] SQL injection logic is sound
- [ ] Binary search converges correctly
- [ ] Password reset flow is correct
- [ ] Session handling works properly
- [ ] SSL verification bypass works (when needed)

### Documentation
- [ ] README is clear and comprehensive
- [ ] All examples are correct and tested
- [ ] Code comments are helpful
- [ ] No typos or grammatical errors
- [ ] Links all work (no 404s)
- [ ] Legal disclaimers are prominent

### Code Quality
- [ ] No hardcoded credentials or sensitive data
- [ ] Proper exception handling throughout
- [ ] Logging is consistent and informative
- [ ] Code follows PEP 8 standards
- [ ] Functions have docstrings
- [ ] Variables have meaningful names

## Test Results Log

### Date: ____________

| Test Category | Status | Notes |
|---------------|--------|-------|
| Syntax Check | ☐ Pass ☐ Fail | |
| Linting | ☐ Pass ☐ Fail | |
| Dependencies | ☐ Pass ☐ Fail | |
| Help Command | ☐ Pass ☐ Fail | |
| Examples | ☐ Pass ☐ Fail | |
| Documentation | ☐ Pass ☐ Fail | |
| Cross-Platform | ☐ Pass ☐ Fail | |
| Security Scan | ☐ Pass ☐ Fail | |

### Issues Found:
1. 
2. 
3. 

### Issues Fixed:
1. 
2. 
3. 

## Performance Tests

### Response Time Test
```powershell
# Measure execution time
Measure-Command { python invision-sqli-exploit.py --help }
```
**Expected:** < 1 second

### Memory Usage Test
```powershell
# Monitor memory during execution
# (Requires Process Monitor or similar tool)
```

## Final Pre-Release Checklist

Before pushing to GitHub:

- [ ] All tests pass
- [ ] No sensitive data in code or git history
- [ ] All URLs updated with correct username
- [ ] Version number is correct (v1.0.0)
- [ ] CHANGELOG is up to date
- [ ] README badges work
- [ ] License file is present
- [ ] .gitignore is configured
- [ ] No debug code or TODOs left in
- [ ] All example scripts tested
- [ ] Documentation reviewed
- [ ] Legal disclaimers prominent
- [ ] GitHub Actions workflow configured
- [ ] Issue templates created
- [ ] Repository description written

## Post-Release Testing

After pushing to GitHub:

- [ ] Clone from GitHub and test
- [ ] Check GitHub Actions runs successfully
- [ ] Verify all files are present
- [ ] Test installation from scratch
- [ ] Check badges display correctly
- [ ] Verify links work
- [ ] Test on clean system (VM)

---

## Quick Test Script

Save as `quick_test.ps1`:

```powershell
# Quick Test Script for Invision SQLi Exploit

Write-Host "Running Quick Tests..." -ForegroundColor Cyan

# 1. Syntax check
Write-Host "`n[1/6] Checking syntax..." -ForegroundColor Yellow
python -m py_compile invision-sqli-exploit.py
if ($LASTEXITCODE -eq 0) {
    Write-Host "✓ Syntax check passed" -ForegroundColor Green
} else {
    Write-Host "✗ Syntax check failed" -ForegroundColor Red
    exit 1
}

# 2. Import check
Write-Host "`n[2/6] Checking imports..." -ForegroundColor Yellow
$output = python -c "import requests; import colorama; print('OK')" 2>&1
if ($output -like "*OK*") {
    Write-Host "✓ All imports successful" -ForegroundColor Green
} else {
    Write-Host "✗ Import check failed" -ForegroundColor Red
    exit 1
}

# 3. Help command
Write-Host "`n[3/6] Testing help command..." -ForegroundColor Yellow
$output = python invision-sqli-exploit.py --help 2>&1
if ($output -like "*usage*") {
    Write-Host "✓ Help command works" -ForegroundColor Green
} else {
    Write-Host "✗ Help command failed" -ForegroundColor Red
    exit 1
}

# 4. Check required files
Write-Host "`n[4/6] Checking required files..." -ForegroundColor Yellow
$files = @("README.md", "LICENSE", "requirements.txt", "SECURITY.md")
$missing = @()
foreach ($file in $files) {
    if (!(Test-Path $file)) {
        $missing += $file
    }
}
if ($missing.Count -eq 0) {
    Write-Host "✓ All required files present" -ForegroundColor Green
} else {
    Write-Host "✗ Missing files: $($missing -join ', ')" -ForegroundColor Red
    exit 1
}

# 5. Example scripts
Write-Host "`n[5/6] Testing example scripts..." -ForegroundColor Yellow
$examples = Get-ChildItem -Path "examples" -Filter "*.py"
$failed = 0
foreach ($example in $examples) {
    $output = python $example.FullName --help 2>&1
    if ($output -like "*usage*" -or $output -like "*error*") {
        Write-Host "  ✓ $($example.Name)" -ForegroundColor Green
    } else {
        Write-Host "  ✗ $($example.Name)" -ForegroundColor Red
        $failed++
    }
}
if ($failed -eq 0) {
    Write-Host "✓ All examples work" -ForegroundColor Green
} else {
    Write-Host "✗ $failed example(s) failed" -ForegroundColor Red
}

# 6. Git check
Write-Host "`n[6/6] Checking git status..." -ForegroundColor Yellow
if (Test-Path ".git") {
    Write-Host "✓ Git repository initialized" -ForegroundColor Green
} else {
    Write-Host "! Git not initialized (run 'git init')" -ForegroundColor Yellow
}

Write-Host "`n" + "="*50 -ForegroundColor Cyan
Write-Host "All quick tests completed!" -ForegroundColor Green
Write-Host "="*50 -ForegroundColor Cyan
```

Run with:
```powershell
.\quick_test.ps1
```

---

**Testing Complete!** ✅

Once all tests pass, you're ready to publish to GitHub!
