# Contributing to Invision Community SQLi Exploit

First off, thank you for considering contributing to this project! This is a security research tool, and we welcome contributions that improve its functionality, documentation, or educational value.

## Table of Contents
- [Code of Conduct](#code-of-conduct)
- [How Can I Contribute?](#how-can-i-contribute)
- [Development Setup](#development-setup)
- [Coding Standards](#coding-standards)
- [Commit Guidelines](#commit-guidelines)
- [Pull Request Process](#pull-request-process)

## Code of Conduct

### Our Pledge

This project is dedicated to **ethical security research and education**. By contributing, you agree to:

- ✅ Use this tool only for legal and authorized purposes
- ✅ Respect responsible disclosure practices
- ✅ Help improve security education
- ✅ Be respectful and professional
- ❌ Never promote or facilitate illegal activities
- ❌ Never use this for unauthorized access
- ❌ Never share exploitation techniques for malicious purposes

## How Can I Contribute?

### Reporting Bugs

If you find a bug, please create an issue with:

1. **Clear title**: "Bug: [Brief description]"
2. **Environment details**:
   - Python version
   - OS (Windows/Linux/Mac)
   - Dependencies versions
3. **Steps to reproduce**
4. **Expected behavior**
5. **Actual behavior**
6. **Error messages** (if any)
7. **Screenshots** (if applicable)

**Example:**
```markdown
### Bug: CSRF token extraction fails on custom domains

**Environment:**
- Python 3.9.5
- Windows 10
- requests 2.31.0

**Steps to reproduce:**
1. Run: `python invision-sqli-exploit.py -u http://custom-domain.local/forum/`
2. Script attempts to extract CSRF token
3. Error occurs

**Expected:** CSRF token extracted successfully
**Actual:** "CSRF token not found in response!"

**Error message:**
[Paste full error here]
```

### Suggesting Enhancements

We welcome suggestions for:

- **New features**: Additional exploitation techniques, output formats, etc.
- **Improvements**: Better error handling, performance optimizations
- **Documentation**: Clearer explanations, more examples
- **Testing**: Additional test cases, validation methods

Create an issue with:
1. **Clear title**: "Enhancement: [Brief description]"
2. **Use case**: Why is this useful?
3. **Proposed solution**: How would it work?
4. **Alternatives considered**: Other approaches?

### Improving Documentation

Documentation improvements are always welcome:

- Fix typos or clarify confusing sections
- Add more usage examples
- Translate documentation to other languages
- Create video tutorials or blog posts

### Contributing Code

We accept pull requests for:

1. **Bug fixes**
2. **New features** (discuss in an issue first)
3. **Performance improvements**
4. **Code refactoring**
5. **Test coverage improvements**

## Development Setup

### 1. Fork and Clone

```bash
# Fork the repository on GitHub, then:
git clone https://github.com/YOUR-USERNAME/invision-sqli-exploit.git
cd invision-sqli-exploit
```

### 2. Create Virtual Environment

```bash
# Windows
python -m venv venv
.\venv\Scripts\activate

# Linux/Mac
python3 -m venv venv
source venv/bin/activate
```

### 3. Install Dependencies

```bash
pip install -r requirements.txt

# Install development dependencies
pip install black flake8 pylint pytest
```

### 4. Create a Branch

```bash
git checkout -b feature/your-feature-name
# or
git checkout -b bugfix/issue-number-description
```

## Coding Standards

### Python Style Guide

We follow [PEP 8](https://www.python.org/dev/peps/pep-0008/) with some modifications:

- **Line length**: Maximum 100 characters (not 79)
- **Indentation**: 4 spaces (no tabs)
- **Quotes**: Double quotes for strings, single quotes for dict keys
- **Docstrings**: Google style

### Code Formatting

Use `black` for automatic formatting:

```bash
black invision-sqli-exploit.py
```

### Linting

Run linters before committing:

```bash
# Flake8 - Style checker
flake8 invision-sqli-exploit.py --max-line-length=100

# Pylint - Code analyzer
pylint invision-sqli-exploit.py
```

### Docstring Format

Use Google-style docstrings:

```python
def example_function(param1, param2):
    """
    Brief description of function.
    
    Longer description if needed, explaining what the function does,
    its purpose, and any important details.
    
    Args:
        param1 (str): Description of param1
        param2 (int): Description of param2
        
    Returns:
        bool: Description of return value
        
    Raises:
        ValueError: When param1 is invalid
        
    Example:
        >>> result = example_function("test", 42)
        >>> print(result)
        True
    """
    # Implementation here
    pass
```

### Comments

- Write self-documenting code when possible
- Use comments for complex logic or non-obvious decisions
- Avoid redundant comments that just repeat the code

**Good:**
```python
# Binary search requires testing values in descending bit order
for i in range(7, -1, -1):
    test = min_val ? test - pow(2, i) : test + pow(2, i)
```

**Bad:**
```python
# Loop through range
for i in range(7, -1, -1):  # This loops from 7 to 0
```

### Error Handling

Always use specific exception types:

```python
# Good
try:
    response = self.session.get(url)
    response.raise_for_status()
except requests.exceptions.HTTPError as e:
    self.log_error(f"HTTP error: {e}")
except requests.exceptions.ConnectionError as e:
    self.log_error(f"Connection error: {e}")
    
# Bad
try:
    response = self.session.get(url)
except:
    print("Error!")
```

### Security Considerations

When contributing code:

1. **Never hardcode credentials** or sensitive data
2. **Validate all user inputs** to prevent injection
3. **Use secure defaults** (e.g., HTTPS over HTTP when possible)
4. **Avoid unnecessary privileges** in code execution
5. **Document security implications** of new features

## Commit Guidelines

### Commit Message Format

```
<type>(<scope>): <subject>

<body>

<footer>
```

### Types

- **feat**: New feature
- **fix**: Bug fix
- **docs**: Documentation changes
- **style**: Code style changes (formatting, no logic change)
- **refactor**: Code refactoring (no feature change)
- **perf**: Performance improvements
- **test**: Adding or updating tests
- **chore**: Maintenance tasks

### Examples

```bash
# Feature
git commit -m "feat(extraction): Add support for custom SQL queries"

# Bug fix
git commit -m "fix(csrf): Handle CSRF token in different HTML formats"

# Documentation
git commit -m "docs(readme): Add troubleshooting section for SSL errors"

# Refactoring
git commit -m "refactor(sqli): Optimize binary search algorithm"
```

### Good Commit Messages

✅ **Good:**
```
feat(proxy): Add SOCKS proxy support

- Added proxy configuration in session setup
- Updated documentation with proxy examples
- Added error handling for proxy connection failures

Closes #42
```

❌ **Bad:**
```
fixed stuff
```

## Pull Request Process

### Before Submitting

1. **Test your changes thoroughly**
2. **Update documentation** if needed
3. **Add/update tests** if applicable
4. **Run linters** and fix any issues
5. **Update CHANGELOG.md** with your changes

### PR Checklist

```markdown
- [ ] Code follows project style guidelines
- [ ] Code has been tested and works as expected
- [ ] Documentation has been updated
- [ ] Commit messages follow guidelines
- [ ] No merge conflicts with main branch
- [ ] All tests pass (if applicable)
```

### PR Template

When creating a PR, include:

```markdown
## Description
Brief description of changes

## Type of Change
- [ ] Bug fix
- [ ] New feature
- [ ] Documentation update
- [ ] Code refactoring
- [ ] Performance improvement

## Testing
How was this tested?

## Checklist
- [ ] Code follows style guidelines
- [ ] Self-review completed
- [ ] Documentation updated
- [ ] No new warnings generated

## Related Issues
Closes #(issue number)
```

### Review Process

1. **Automated checks** will run on your PR
2. **Maintainers will review** your code
3. **Feedback will be provided** if changes needed
4. **Approval and merge** once everything looks good

### After Your PR is Merged

1. Delete your feature branch
2. Pull the latest main branch
3. Celebrate! 🎉

## Questions?

If you have questions about contributing:

1. Check existing issues and PRs
2. Read the documentation thoroughly
3. Create a new issue with your question

## Recognition

Contributors will be:

- Listed in CONTRIBUTORS.md
- Mentioned in release notes
- Given credit in documentation

Thank you for helping make security research more accessible and educational! 🛡️

---

**Remember**: All contributions must comply with ethical hacking principles and responsible disclosure practices.
