# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0] - 2025-11-14

### Added
- Initial release of Python version
- Complete rewrite from PHP to Python 3
- User-friendly command-line interface with colored output
- Verbose mode for debugging (`-v` flag)
- Comprehensive error handling and logging
- Cross-platform support (Windows, Linux, macOS)
- Session management with automatic cookie handling
- Binary search algorithm for efficient data extraction
- CSRF token automatic extraction
- Real-time progress display during data extraction
- User consent prompt before exploitation
- SSL verification bypass for testing environments
- Comprehensive documentation (README, USAGE, CONTRIBUTING, SECURITY)
- MIT License with security research disclaimer
- Requirements file with pinned dependencies
- .gitignore configured for Python projects

### Features
- **Automated CSRF Token Extraction**: Automatically fetches and uses CSRF tokens
- **Boolean-Based Blind SQL Injection**: Efficient character-by-character extraction
- **Admin Email Extraction**: Retrieves administrator email from database
- **Password Reset Key Extraction**: Gets validation key for password reset
- **Automatic Password Reset**: Resets admin password automatically
- **Colored Output**: User-friendly colored terminal output using colorama
- **Error Recovery**: Graceful handling of network and application errors
- **Verbose Mode**: Detailed debugging information when needed

### Security
- SSL verification disabled by default for testing (can be enabled)
- No credentials stored in code
- Session data properly cleaned up
- Disclaimer and consent prompt before execution

### Documentation
- Comprehensive README with badges and detailed sections
- Step-by-step usage guide (USAGE.md)
- Contributing guidelines (CONTRIBUTING.md)
- Security policy and responsible disclosure guidelines (SECURITY.md)
- Code of conduct for ethical use
- Example output and troubleshooting tips

### Technical Details
- Python 3.7+ compatibility
- Object-oriented design with InvisionSQLiExploit class
- Requests library for HTTP operations
- Colorama for cross-platform colored output
- Argparse for command-line argument parsing
- Regular expressions for data extraction
- Binary search algorithm for optimization

## [Future Releases]

### Planned Features
- [ ] Batch testing mode for multiple targets
- [ ] Custom SQL query execution mode
- [ ] Export results to JSON/CSV format
- [ ] Proxy support (HTTP/SOCKS)
- [ ] Tor integration for anonymity
- [ ] GUI interface option
- [ ] Docker container support
- [ ] Integration with Metasploit Framework
- [ ] Additional database extraction templates
- [ ] Progress saving/resuming for long extractions
- [ ] Rate limiting to avoid detection
- [ ] User-agent rotation
- [ ] Custom timeout configuration via CLI

### Potential Improvements
- [ ] Optimize binary search algorithm further
- [ ] Add multithreading for faster extraction
- [ ] Implement blind SQL injection detection
- [ ] Add WAF detection and bypass techniques
- [ ] Create automated testing suite
- [ ] Add logging to file option
- [ ] Implement retry logic for failed requests
- [ ] Add configuration file support
- [ ] Create web-based dashboard for results

---

## Version History

### Version Numbering
- **Major version** (X.0.0): Incompatible API changes or major rewrites
- **Minor version** (0.X.0): New features, backward compatible
- **Patch version** (0.0.X): Bug fixes, backward compatible

### Release Notes Format

Each release should include:
- **Added**: New features
- **Changed**: Changes to existing functionality
- **Deprecated**: Features to be removed in future
- **Removed**: Removed features
- **Fixed**: Bug fixes
- **Security**: Vulnerability fixes

---

## Contributing

See [CONTRIBUTING.md](CONTRIBUTING.md) for information on how to contribute to this project.

## Original Work

This Python implementation is based on publicly disclosed vulnerability information:
- **Developer**: nanda
- **CVE**: CVE-2025-48932
- **EDB-ID**: 52383

## Acknowledgments

- Security research community for ethical disclosure practices
- Invision Community for prompt patching
- Python community for excellent libraries (requests, colorama)
- Open source contributors

---

**Note**: This is a security research tool. Always use responsibly and legally.
