# 💥 vBulletin Remote Code Execution Scanner (replaceAdTemplate)

This Python tool automates the detection of **unauthenticated RCE** vulnerabilities in **vBulletin** via the `replaceAdTemplate` exploit vector. Based on the original proof-of-concept by **EgiX**, this version supports **batch scanning**, **multithreading**, and logs confirmed vulnerable targets to `vuln.txt`.

## 🔥 Vulnerability Details

- **Exploit Name**: `replaceAdTemplate` RCE
- **CVE**: CVE-2025-48828
- **Affected**: Vulnerable versions of vBulletin using the `ajax/api/ad/replaceAdTemplate` route
- **Impact**: Remote Code Execution (unauthenticated)

## ⚙️ Features

- 🧠 Automatic command execution (`id`) to confirm RCE
- 🔎 Batch scan from a file (`targets.txt`)
- ⚡ Fast, multi-threaded scanner
- 🧾 Logs vulnerable targets and their output to `vuln.txt`
- 💬 Clean, modular codebase

## 📦 Requirements

- Python 3.x
- `requests` module

Install dependencies (if not already installed):

```bash
pip install requests
```

## 📂 Usage

1. Prepare your target list
Create a file named targets.txt and add one target URL per line:
```
http://example.com/vb/
https://target.net/forum/
192.168.1.100:8080/vb/
```

2. Run the scanner:
```
python3 scanner.py
```

3. Check vuln.txt for results:
```
http://victim.com/vb | uid=33(www-data) gid=33(www-data) groups=33(www-data)
```

## ⚙️ Configuration

You can change these settings in the script:

COMMAND: Shell command to execute (default: id)

EXPECTED_OUTPUT: Expected substring to confirm execution (default: uid=)

THREADS: Number of concurrent scans (default: 20)

TARGET_FILE: Input file of domains (default: targets.txt)

OUTPUT_FILE: Output log file (default: vuln.txt)


## ⚠️ Disclaimer

This code is provided for educational and authorized security testing purposes only. Unauthorized use against systems without permission is illegal. The author and contributors are not responsible for misuse or damage caused by this software.

## 🙏 Credits

Original exploit author: EgiX

Python adaptation & batch scanner: ill deed


## 📄 License

MIT License – use responsibly.

