
import asyncio
from bleak import BleakScanner, BleakClient

TARGET_NAME = "BloodDevice"  # Zameni sa imenom meta uređaja

async def main():
    print("[*] Skeniram BLE uređaje u blizini...")
    devices = await BleakScanner.discover()
    
    for d in devices:
        print(f"[+] Pronađen: {d.name} [{d.address}]")
        if TARGET_NAME.lower() in str(d.name).lower():
            print(f"[!] Target detektovan: {d.name} -> pokušavam konekciju...")
            try:
                async with BleakClient(d.address) as client:
                    svcs = await client.get_services()
                    print(f"[+] Servisi: {svcs.services}")
                    # TODO: Insert advanced payload here (PRIVATE)
            except Exception as e:
                print(f"[!] Greška: {e}")

if __name__ == "__main__":
    asyncio.run(main())
