# CVE-2025-48466
Modbus Packet Injection on Advantech WISE 4060LAN / IoT Gateway for door control. (see script: main.py)

# Summary
I was able to figure out that it is just very easy to somehow manipulate the Modbus server running on an IoT Gateway for door control on a network. Any remote attacker without even having access to the admin panel of WISE-4060/LAN can execute the script and cause disruption or toggling of the Digital Output (DO) of the WISE-4060/LAN 4-channel Digital Input / 4-channel Relay Output IoT Ethernet I/O Module.

This vulnerability was discovered during our stint at SPIRITCYBER-24 IoT / OT Hackathon at Singapore. 

# Impact

Consequences: Remote attackers can execute Modbus commands to WISE-4060/LAN module and manipulate the DO channels. This could lead to unauthorized control of connected devices, such as turning systems on or off, causing disruptions or unsafe conditions.

In industrial settings, the DO channels might control critical systems like power relays, alarms, or machinery. In this case it is for door control .Unauthorized manipulation could lead to dangerous conditions, safety hazards, or equipment damage.

An attacker might capture valid Modbus commands and replay them later, causing unintended actions like toggling DO channels at inappropriate times.

# main.py

Here is the output when running the script which fuzzes the addresses for the DO. Successful responses have 0x00 on the end while 0x02 is for fails.

<img width="446" alt="image" src="https://github.com/user-attachments/assets/025ec5ce-ec17-4bf6-825d-721e5324e569" />

# PoC Video
https://github.com/user-attachments/assets/b0dccbd9-7974-430b-af5e-2198daf735db





