#include <dlfcn.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

int main()
{

	void (*hello)(void);
	printf("\n BEGINNING OF MAIN\n");

 	void *handle = dlopen("myso.so", RTLD_NOW);
	if (!handle) 
	{
		fprintf(stderr, "%s\n", dlerror());
		exit(1);
	}

	dlerror(); // clear errors ?

	// do some classic root stuff
	uid_t root = 0;
	if (setuid(root) == -1)
	{
		perror("setuid failed");
		return 1;
	}

	
	// call function from so
	*(void **) &hello = dlsym(handle, "hello");

	char *error = dlerror();
	if (error != NULL)
	{
		fprintf(stderr, "%s\n", error);
	 	exit(EXIT_FAILURE);
	}

	(*hello)(); // will this even work as a function call 

	printf("\n END OF MAIN\n");

	dlclose(handle);
	return 0;
}

